/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.GridEditGuard;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellEditorTextField
extends EditorTextField
implements Disposable {
    private final DataGrid myGrid;

    public GridCellEditorTextField(final Project project, @NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, final @NotNull ModelIndex<GridColumn> column, boolean multiline, EventObject initiator, TextCompletionProvider provider, boolean autoPopup, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
        boolean clear;
        if (grid == null) {
            GridCellEditorTextField.$$$reportNull$$$0(0);
        }
        if (row == null) {
            GridCellEditorTextField.$$$reportNull$$$0(1);
        }
        if (column == null) {
            GridCellEditorTextField.$$$reportNull$$$0(2);
        }
        if (valueFormatter == null) {
            GridCellEditorTextField.$$$reportNull$$$0(3);
        }
        super(GridCellEditorTextField.createDocument(DefaultTextRendererFactory.getLanguage(grid, row, column)), project, (FileType)FileTypes.PLAIN_TEXT);
        boolean bl = clear = initiator instanceof KeyEvent && grid.isEditable();
        if (!clear) {
            this.setText(valueFormatter, grid, row, column);
        }
        this.putClientProperty("JBListTable.isTableCellEditor", Boolean.TRUE);
        this.myGrid = grid;
        this.installEditorSettingsProvider(multiline);
        GridCellEditorTextField.installCompletion(project, this.getDocument(), provider, autoPopup);
        this.myGrid.addDataGridListener(new DataGridListener(){

            @Override
            public void onCellLanguageChanged(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull Language language) {
                if (columnIdx == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (language == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!columnIdx.equals((Object)column)) {
                    return;
                }
                LightVirtualFile file = (LightVirtualFile)ObjectUtils.tryCast((Object)FileDocumentManager.getInstance().getFile(GridCellEditorTextField.this.getDocument()), LightVirtualFile.class);
                if (file == null) {
                    return;
                }
                file.setLanguage(language);
                EditorEx editor = (EditorEx)ObjectUtils.tryCast((Object)GridCellEditorTextField.this.getEditor(), EditorEx.class);
                if (editor != null) {
                    editor.setHighlighter(HighlighterFactory.createHighlighter((Project)project, (VirtualFile)file));
                }
                FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "columnIdx";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "language";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$1";
                objectArray[2] = "onCellLanguageChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
    }

    public void setText(@NotNull GridCellEditorFactory.ValueFormatter valueFormatter, @NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (valueFormatter == null) {
            GridCellEditorTextField.$$$reportNull$$$0(4);
        }
        if (grid == null) {
            GridCellEditorTextField.$$$reportNull$$$0(5);
        }
        if (row == null) {
            GridCellEditorTextField.$$$reportNull$$$0(6);
        }
        if (column == null) {
            GridCellEditorTextField.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            GridCellEditorFactory.ValueFormatterResult result = valueFormatter.format();
            VirtualFile file = FileDocumentManager.getInstance().getFile(this.getDocument());
            if (file != null) {
                file.setCharset(result.charset);
                file.setBOM(result.bom);
            }
            this.setText(result.text);
            PsiCodeFragment fragment = GridHelper.get(grid).createCellCodeFragment(this.getDocument().getText(), this.getProject(), grid, row, column);
            if (fragment != null) {
                GridUtilCore.associatePsiSafe((Document)this.getDocument(), (PsiFile)fragment);
            }
        });
    }

    protected boolean shouldHaveBorder() {
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Editor editor = this.getEditor();
        if (editor instanceof EditorEx && !editor.isOneLineMode()) {
            JScrollBar horizontalScrollBar;
            JScrollPane scrollPane = ((EditorEx)editor).getScrollPane();
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            if (verticalScrollBar != null) {
                size.width += verticalScrollBar.getWidth();
            }
            if ((horizontalScrollBar = scrollPane.getHorizontalScrollBar()) != null) {
                size.height += horizontalScrollBar.getHeight();
            }
        }
        return size;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            GridCellEditorTextField.$$$reportNull$$$0(8);
        }
        super.uiDataSnapshot(sink);
        VirtualFile file = FileDocumentManager.getInstance().getFile(this.getDocument());
        if (file != null) {
            file.putUserData(NavBarModelExtension.IGNORE_IN_NAVBAR, (Object)true);
        }
        sink.set(CommonDataKeys.VIRTUAL_FILE, (Object)file);
        Editor editor = this.getEditor();
        sink.set(CommonDataKeys.EDITOR, (Object)editor);
        if (editor != null) {
            sink.set(PlatformCoreDataKeys.FILE_EDITOR, (Object)TextEditorProvider.getInstance().getTextEditor(editor));
        }
    }

    public void dispose() {
    }

    protected boolean isEditable() {
        return this.myGrid.isEditable();
    }

    private void registerEnterAction(@NotNull Editor editor, final boolean multiline) {
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(9);
        }
        CustomShortcutSet enterAndControlEnter = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)"ENTER"), KeyboardShortcut.fromString((String)"control ENTER")});
        DumbAwareAction action = new DumbAwareAction("insertNewLineOrStopEditing1"){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(LookupManager.getActiveLookup((Editor)GridCellEditorTextField.this.getEditor()) == null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                InputEvent inputEvent;
                boolean isCtrlEnter;
                if (e == null) {
                    2.$$$reportNull$$$0(2);
                }
                boolean bl = isCtrlEnter = (inputEvent = e.getInputEvent()) instanceof KeyEvent && inputEvent.isControlDown();
                if (multiline && isCtrlEnter) {
                    2.performEditorEnter(e);
                } else {
                    GridCellEditorTextField.this.myGrid.stopEditing();
                }
            }

            private static void performEditorEnter(@NotNull AnActionEvent e) {
                AnAction action;
                if (e == null) {
                    2.$$$reportNull$$$0(3);
                }
                if ((action = ActionManager.getInstance().getAction("EditorEnter")) == null) {
                    return;
                }
                ActionUtil.performAction((AnAction)action, (AnActionEvent)e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$2";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "performEditorEnter";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        };
        GridCellEditorTextField.registerAction(editor, (AnAction)action, (ShortcutSet)enterAndControlEnter);
    }

    private void registerTabAction(@NotNull EditorEx editor) {
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(10);
        }
        CustomShortcutSet tabAndShiftTab = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)"TAB"), KeyboardShortcut.fromString((String)"shift TAB")});
        DumbAwareAction action = new DumbAwareAction("insertTabOrStopEditing"){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                KeyEvent keyEvent = (KeyEvent)ObjectUtils.tryCast((Object)e.getInputEvent(), KeyEvent.class);
                e.getPresentation().setEnabledAndVisible(keyEvent != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(2);
                }
                JComponent gridComponent = GridCellEditorTextField.this.myGrid.getPreferredFocusedComponent();
                KeyEvent keyEvent = (KeyEvent)e.getInputEvent();
                KeyStroke stroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                Object actionKey = gridComponent.getInputMap(1).get(stroke);
                Action tabAction = gridComponent.getActionMap().get(actionKey);
                if (tabAction != null) {
                    tabAction.actionPerformed(new ActionEvent(gridComponent, keyEvent.getID(), keyEvent.toString(), keyEvent.getWhen(), keyEvent.getModifiers()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$3";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
        GridCellEditorTextField.registerAction((Editor)editor, (AnAction)action, (ShortcutSet)tabAndShiftTab);
    }

    private void registerArrowAction(final @NotNull EditorEx editor) {
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(11);
        }
        final KeyboardShortcut up = KeyboardShortcut.fromString((String)"UP");
        KeyboardShortcut down = KeyboardShortcut.fromString((String)"DOWN");
        DumbAwareAction action = new DumbAwareAction("goToPreviousOrNextLineOrStopEditing"){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    4.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (editor.getDocument().getLineCount() > 1) {
                    e.getPresentation().setEnabledAndVisible(false);
                    return;
                }
                KeyEvent keyEvent = (KeyEvent)ObjectUtils.tryCast((Object)e.getInputEvent(), KeyEvent.class);
                e.getPresentation().setEnabledAndVisible(keyEvent != null && LookupManager.getActiveLookup((Editor)GridCellEditorTextField.this.getEditor()) == null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Action action;
                if (e == null) {
                    4.$$$reportNull$$$0(2);
                }
                KeyEvent keyEvent = (KeyEvent)e.getInputEvent();
                JComponent gridComponent = GridCellEditorTextField.this.myGrid.getPreferredFocusedComponent();
                ActionMap actionMap = gridComponent.getActionMap();
                Action action2 = action = up.getFirstKeyStroke().getKeyCode() == keyEvent.getKeyCode() ? actionMap.get("selectPreviousRow") : actionMap.get("selectNextRow");
                if (action == null) {
                    return;
                }
                action.actionPerformed(new ActionEvent(gridComponent, keyEvent.getID(), keyEvent.toString(), keyEvent.getWhen(), keyEvent.getModifiers()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$4";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
        GridCellEditorTextField.registerAction((Editor)editor, (AnAction)action, (ShortcutSet)new CustomShortcutSet(new Shortcut[]{up, down}));
    }

    private static void registerAction(@NotNull Editor editor, @NotNull AnAction action, @NotNull ShortcutSet shortcutSet) {
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(12);
        }
        if (action == null) {
            GridCellEditorTextField.$$$reportNull$$$0(13);
        }
        if (shortcutSet == null) {
            GridCellEditorTextField.$$$reportNull$$$0(14);
        }
        action.registerCustomShortcutSet(shortcutSet, editor.getComponent());
    }

    private void installEditorSettingsProvider(boolean multiline) {
        this.addSettingsProvider(editor -> {
            editor.setRendererMode(!this.isEditable());
            EditorColorsScheme scheme = editor.createBoundColorSchemeDelegate((EditorColorsScheme)this.myGrid.getColorsScheme());
            if (UISettings.getInstance().getPresentationMode()) {
                scheme.setEditorFontSize(UISettingsUtils.getInstance().getPresentationModeFontSize());
            }
            editor.setColorsScheme(scheme);
            editor.setBackgroundColor(scheme.getDefaultBackground());
            editor.setOneLineMode(false);
            editor.setVerticalScrollbarVisible(multiline);
            editor.setHorizontalScrollbarVisible(multiline);
            editor.getSettings().setAdditionalColumnsCount(2);
            editor.getCaretModel().moveToOffset(0);
            if (this.isEditable() && (!multiline || this.getDocument().getLineCount() == 1)) {
                editor.getSelectionModel().setSelection(0, this.getDocument().getTextLength());
            }
            this.putReadOnlyText(editor);
            editor.installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler.Simple("Console.TableResult.CellEditor.Popup"));
            this.registerEnterAction((Editor)editor, multiline);
            this.registerTabAction(editor);
            if (multiline) {
                this.registerArrowAction(editor);
            }
        });
    }

    private void putReadOnlyText(@NotNull EditorEx editor) {
        GridEditGuard guard;
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(15);
        }
        if ((guard = GridEditGuard.get((CoreGrid)this.myGrid)) == null) {
            return;
        }
        EditorModificationUtil.setReadOnlyHint((Editor)editor, (String)guard.getReasonText((CoreGrid)this.myGrid));
    }

    @NotNull
    private static Document createDocument(@NotNull Language language) {
        if (language == null) {
            GridCellEditorTextField.$$$reportNull$$$0(16);
        }
        PlainTextLanguage lang = language == Language.ANY ? PlainTextLanguage.INSTANCE : language;
        LightVirtualFile file = new LightVirtualFile("GridCellEditorTextField", (Language)lang, (CharSequence)"");
        Document doc = FileDocumentManager.getInstance().getDocument((VirtualFile)file);
        Document document = doc != null ? doc : EditorFactory.getInstance().createDocument((CharSequence)"");
        if (document == null) {
            GridCellEditorTextField.$$$reportNull$$$0(17);
        }
        return document;
    }

    private static void installCompletion(@NotNull Project project, @Nullable Document document, @Nullable TextCompletionProvider provider, boolean autoPopup) {
        if (project == null) {
            GridCellEditorTextField.$$$reportNull$$$0(18);
        }
        if (document == null || provider == null) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile != null) {
            TextCompletionUtil.installProvider((PsiFile)psiFile, (TextCompletionProvider)provider, (boolean)autoPopup);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFormatter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSet";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerEnterAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerTabAction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerArrowAction";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerAction";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "putReadOnlyText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "installCompletion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17 -> new IllegalStateException(string);
        };
    }
}

