/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.property.set.SetProperty;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.internal.databinding.viewers.CheckableCheckedElementsObservableSet;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.internal.databinding.viewers.ViewerObservableSetDecorator;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

public class CheckableCheckedElementsProperty<S extends ICheckable, E>
extends SetProperty<S, E> {
    private final Object elementType;

    public CheckableCheckedElementsProperty(Object elementType) {
        this.elementType = elementType;
    }

    public Object getElementType() {
        return this.elementType;
    }

    protected Set<E> doGetSet(S source) {
        throw new UnsupportedOperationException("Cannot query the checked elements on an ICheckable");
    }

    protected void doSetSet(S source, Set<E> set) {
        throw new UnsupportedOperationException("Cannot batch replace the checked elements on an ICheckable.  Use updateSet(SetDiff) instead");
    }

    protected void doUpdateSet(S source, SetDiff<E> diff) {
        for (Object e : diff.getAdditions()) {
            source.setChecked(e, true);
        }
        for (Object e : diff.getRemovals()) {
            source.setChecked(e, false);
        }
    }

    public IObservableSet<E> observe(S source) {
        if (source instanceof Viewer) {
            return this.observe(DisplayRealm.getRealm(((Viewer)source).getControl().getDisplay()), source);
        }
        return super.observe(source);
    }

    public IObservableSet<E> observe(Realm realm, S source) {
        IElementComparer comparer = null;
        if (source instanceof StructuredViewer) {
            comparer = ((StructuredViewer)source).getComparer();
        }
        Set wrappedSet = ViewerElementSet.withComparer(comparer);
        Object observable = new CheckableCheckedElementsObservableSet(realm, wrappedSet, this.elementType, comparer, (ICheckable)source);
        if (source instanceof Viewer) {
            observable = new ViewerObservableSetDecorator(observable, (Viewer)source);
        }
        return observable;
    }
}

