/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.transformers;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.ProxyValueHandler;
import org.jkiss.dbeaver.model.impl.data.transformers.TransformerPresentationAttribute;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class PercentOfTotalGroupingAttributeTransformer
implements DBDAttributeTransformer {
    public static final String TYPE_NAME = "percent";
    private static final Log log = Log.getLog(PercentOfTotalGroupingAttributeTransformer.class);
    private static final DecimalFormat df = new DecimalFormat("0.####%");
    private final TotalRowCountProvider totalRowCountSupplier;

    public PercentOfTotalGroupingAttributeTransformer(@NotNull TotalRowCountProvider totalRowCountSupplier) {
        this.totalRowCountSupplier = totalRowCountSupplier;
    }

    @Override
    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, Object> options) throws DBException {
        long totalRows = this.totalRowCountSupplier.getTotalRowCount(session.getProgressMonitor());
        attribute.setPresentationAttribute(new TransformerPresentationAttribute(attribute, TYPE_NAME, -1, DBPDataKind.NUMERIC));
        attribute.setTransformHandler(new PercentOfTotalValueHandler(attribute.getValueHandler(), totalRows));
    }

    private class PercentOfTotalValueHandler
    extends ProxyValueHandler {
        private final long total;

        public PercentOfTotalValueHandler(DBDValueHandler target, long total) {
            super(target);
            if (total < 0L) {
                throw new IllegalArgumentException("Total must be non-negative, but got: " + total);
            }
            this.total = total;
        }

        @Override
        @Nullable
        public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy, boolean validateValue) throws DBCException {
            if (object instanceof Number) {
                Number rowCount = (Number)object;
                return this.percentOfTotal(rowCount.doubleValue(), this.total);
            }
            return super.getValueFromObject(session, type, object, copy, validateValue);
        }

        @Override
        @NotNull
        public String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
            if (value == null) {
                return "";
            }
            if (value instanceof Number) {
                Number rowCount = (Number)value;
                return this.formatPercent(this.percentOfTotal(rowCount.doubleValue(), this.total));
            }
            log.trace("Unexpected value type for PercentOfTotalValueHandler: " + value.getClass().getName());
            return super.getValueDisplayString(column, value, format);
        }

        private double percentOfTotal(double value, double total) {
            if (total == 0.0) {
                return 0.0;
            }
            return value / total;
        }

        @NotNull
        private String formatPercent(double percent) {
            return df.format(percent);
        }
    }

    @FunctionalInterface
    public static interface TotalRowCountProvider {
        public long getTotalRowCount(@NotNull DBRProgressMonitor var1) throws DBException;
    }
}

