/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.nativetool;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.tasks.nativetool.NativeToolUtils;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractNativeToolWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.internal.TaskNativeUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.IWizardPageNavigable;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class NativeToolWizardPageLog
extends WizardPage
implements IWizardPageNavigable {
    private static final Log log = Log.getLog(NativeToolWizardPageLog.class);
    private TextConsoleViewer consoleViewer;
    private final String task;
    private PrintStream writer;
    private MessageConsole console;

    public NativeToolWizardPageLog(String task) {
        super(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_progress, (Object)task));
        this.task = task;
        this.setTitle(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_progress, (Object)task));
        this.setDescription(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_progress_log, (Object)task));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new FillLayout());
        this.console = new MessageConsole("tool-log-console", null);
        this.consoleViewer = new LogConsoleViewer(this, composite);
        this.console.setWaterMarks(0x300000, 0x400000);
        this.writer = new PrintStream((OutputStream)this.console.newMessageStream(), true, StandardCharsets.UTF_8);
        this.setControl((Control)composite);
    }

    public PrintStream getLogWriter() {
        return this.writer;
    }

    public void appendLog(String line) {
        this.appendLog(line, false);
    }

    public void appendLog(String line, boolean error) {
        if (this.getShell().isDisposed()) {
            return;
        }
        this.writer.print(line);
    }

    public void clearLog() {
        if (this.getShell().isDisposed()) {
            return;
        }
        UIUtils.syncExec(() -> {
            NativeToolWizardPageLog nativeToolWizardPageLog = this;
            synchronized (nativeToolWizardPageLog) {
                this.console.clearConsole();
            }
        });
    }

    public void startLogReader(ProcessBuilder processBuilder, InputStream stream) {
        new LogReaderJob(processBuilder, stream).start();
    }

    public void startNullReader(InputStream stream) {
        new NullReaderJob(this, stream).start();
    }

    public boolean isPageNavigable() {
        return false;
    }

    public boolean isPageApplicable() {
        return true;
    }

    private class LogConsoleViewer
    extends TextConsoleViewer
    implements IDocumentListener {
        LogConsoleViewer(NativeToolWizardPageLog nativeToolWizardPageLog, Composite composite) {
            super(composite, (TextConsole)nativeToolWizardPageLog.console);
        }

        protected void createControl(Composite parent, int styles) {
            super.createControl(parent, styles);
            StyledText textWidget = this.getTextWidget();
            textWidget.setWordWrap(true);
        }

        public void setDocument(IDocument document) {
            IDocument oldDocument = this.getDocument();
            super.setDocument(document);
            if (oldDocument != null) {
                oldDocument.removeDocumentListener((IDocumentListener)this);
            }
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.revealEndOfDocument();
        }
    }

    private class LogReaderJob
    extends Thread {
        private final ProcessBuilder processBuilder;
        private final InputStream input;

        LogReaderJob(ProcessBuilder processBuilder, InputStream stream) {
            super(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_log_reader, (Object)NativeToolWizardPageLog.this.task));
            this.processBuilder = processBuilder;
            this.input = stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractNativeToolWizard wizard = (AbstractNativeToolWizard)NativeToolWizardPageLog.this.getWizard();
            String lf = GeneralUtils.getDefaultLineSeparator();
            List<String> command = this.processBuilder.command();
            StringBuilder cmdString = new StringBuilder();
            for (String cmd : command) {
                if (NativeToolUtils.isSecureString(wizard.getSettings(), (String)cmd)) {
                    cmd = "******";
                }
                if (cmdString.length() > 0) {
                    cmdString.append(' ');
                }
                cmdString.append(cmd);
            }
            cmdString.append(lf);
            NativeToolWizardPageLog.this.appendLog(cmdString.toString());
            NativeToolWizardPageLog.this.appendLog(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_started_at, (Object)NativeToolWizardPageLog.this.task, (Object)new Date()) + lf);
            try (InputStreamReader reader = new InputStreamReader(this.input, GeneralUtils.getDefaultConsoleEncoding());){
                int b;
                StringBuilder buf = new StringBuilder();
                while ((b = ((Reader)reader).read()) != -1) {
                    buf.append((char)b);
                    if (b != 10) continue;
                    NativeToolWizardPageLog.this.appendLog(buf.toString());
                    buf.setLength(0);
                }
            }
            catch (IOException e) {
                NativeToolWizardPageLog.this.appendLog(e.getMessage() + lf);
            }
            finally {
                NativeToolWizardPageLog.this.appendLog(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_finished, (Object)NativeToolWizardPageLog.this.task, (Object)new Date()) + lf);
            }
        }
    }

    private class NullReaderJob
    extends Thread {
        private final InputStream input;

        protected NullReaderJob(NativeToolWizardPageLog nativeToolWizardPageLog, InputStream stream) {
            super(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_log_reader, (Object)nativeToolWizardPageLog.task));
            this.input = stream;
        }

        @Override
        public void run() {
            try {
                int count;
                byte[] buffer = new byte[1000];
                while ((count = this.input.read(buffer)) > 0) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

