/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.edge;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.Range;
import org.gephi.filters.plugin.AbstractFilter;
import org.gephi.filters.plugin.graph.RangeUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.RangeFilter;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EdgeWeightBuilder
implements FilterBuilder {
    public Category getCategory() {
        return FilterLibrary.EDGE;
    }

    public String getName() {
        return NbBundle.getMessage(EdgeWeightBuilder.class, (String)"EdgeWeightBuilder.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(EdgeWeightBuilder.class, (String)"EdgeWeightBuilder.description");
    }

    public Filter getFilter(Workspace workspace) {
        return new EdgeWeightFilter();
    }

    public JPanel getPanel(Filter filter) {
        RangeUI ui = (RangeUI)Lookup.getDefault().lookup(RangeUI.class);
        if (ui != null) {
            return ui.getPanel((EdgeWeightFilter)filter);
        }
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class EdgeWeightFilter
    extends AbstractFilter
    implements RangeFilter,
    EdgeFilter {
        private Range range;

        public EdgeWeightFilter() {
            super(NbBundle.getMessage(EdgeWeightBuilder.class, (String)"EdgeWeightBuilder.name"));
            this.addProperty(Range.class, "range");
        }

        public boolean init(Graph graph) {
            return graph.getEdgeCount() != 0;
        }

        public boolean evaluate(Graph graph, Edge edge) {
            double weight = edge.getWeight(graph.getView());
            return this.range.isInRange((Number)weight);
        }

        public void finish() {
        }

        public Number[] getValues(Graph graph) {
            ArrayList<Double> values = new ArrayList<Double>();
            for (Edge e : graph.getEdges()) {
                double weight = e.getWeight(graph.getView());
                values.add(weight);
            }
            return values.toArray(new Number[0]);
        }

        public FilterProperty getRangeProperty() {
            return this.getProperties()[0];
        }

        public Range getRange() {
            return this.range;
        }

        public void setRange(Range range) {
            this.range = range;
        }
    }
}

