/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.AbstractRenderableDependencyResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;

public class RequestedVersion
extends AbstractRenderableDependencyResult {
    private final ComponentSelector requested;
    private final ComponentIdentifier actual;
    private final boolean resolvable;
    private final Set<RenderableDependency> children = new LinkedHashSet<RenderableDependency>();

    public RequestedVersion(ComponentSelector requested, ComponentIdentifier actual, boolean resolvable) {
        this.requested = requested;
        this.actual = actual;
        this.resolvable = resolvable;
    }

    public void addChild(DependencyEdge child) {
        this.children.addAll(child.getChildren());
    }

    @Override
    protected ComponentIdentifier getActual() {
        return this.actual;
    }

    @Override
    public ComponentSelector getRequested() {
        return this.requested;
    }

    @Override
    public RenderableDependency.ResolutionState getResolutionState() {
        return this.resolvable ? RenderableDependency.ResolutionState.RESOLVED : RenderableDependency.ResolutionState.FAILED;
    }

    public Set<RenderableDependency> getChildren() {
        return this.children;
    }

    public AttributeContainer getAttributes() {
        return this.requested instanceof ModuleComponentSelector ? this.requested.getAttributes() : ImmutableAttributes.EMPTY;
    }
}

