/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.inline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SoftDeleteMapping;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.mutation.internal.DeleteHandler;
import org.hibernate.query.sqm.mutation.internal.MatchingIdSelectionHelper;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.mutation.internal.inline.AbstractInlineHandler;
import org.hibernate.query.sqm.mutation.internal.inline.MatchingIdRestrictionProducer;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.AbstractUpdateOrDeleteStatement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class InlineDeleteHandler
extends AbstractInlineHandler
implements DeleteHandler {
    private final List<TableDeleter> tableDeleters;

    protected InlineDeleteHandler(MatchingIdRestrictionProducer matchingIdsPredicateProducer, SqmDeleteStatement<?> sqmStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context, MutableObject<JdbcParameterBindings> firstJdbcParameterBindingsConsumer) {
        super(matchingIdsPredicateProducer, sqmStatement, domainParameterXref, context, firstJdbcParameterBindingsConsumer);
        ArrayList<TableDeleter> tableDeleters = new ArrayList<TableDeleter>();
        SoftDeleteMapping softDeleteMapping = this.getEntityDescriptor().getSoftDeleteMapping();
        if (softDeleteMapping != null) {
            tableDeleters.add(this.createSoftDeleter());
        } else {
            MutableInteger valueIndexCounter = new MutableInteger();
            SqmMutationStrategyHelper.visitCollectionTables(this.getEntityDescriptor(), pluralAttribute -> {
                if (pluralAttribute.getSeparateCollectionTable() != null) {
                    int valueIndex;
                    ValuedModelPart fkTargetPart = pluralAttribute.getKeyDescriptor().getTargetPart();
                    if (fkTargetPart.isEntityIdentifierMapping()) {
                        valueIndex = 0;
                    } else {
                        if (valueIndexCounter.get() == 0) {
                            valueIndexCounter.set(this.getEntityDescriptor().getIdentifierMapping().getJdbcTypeCount());
                        }
                        valueIndex = valueIndexCounter.get();
                        valueIndexCounter.plus(fkTargetPart.getJdbcTypeCount());
                    }
                    NamedTableReference targetTableReference = new NamedTableReference(pluralAttribute.getSeparateCollectionTable(), "to_delete_");
                    tableDeleters.add(new TableDeleter(new DeleteStatement(targetTableReference, null), () -> fkTargetPart::forEachSelectable, valueIndex, fkTargetPart));
                }
            });
            this.getEntityDescriptor().visitConstraintOrderedTables((tableExpression, tableKeyColumnsVisitationSupplier) -> tableDeleters.add(new TableDeleter(new DeleteStatement(new NamedTableReference(tableExpression, "to_delete_"), null), tableKeyColumnsVisitationSupplier, 0, null)));
        }
        this.tableDeleters = tableDeleters;
    }

    private TableDeleter createSoftDeleter() {
        EntityPersister entityDescriptor = this.getEntityDescriptor();
        TableDetails softDeleteTable = entityDescriptor.getSoftDeleteTableDetails();
        SoftDeleteMapping softDeleteMapping = entityDescriptor.getSoftDeleteMapping();
        assert (softDeleteMapping != null);
        NamedTableReference targetTableReference = new NamedTableReference(softDeleteTable.getTableName(), "to_delete_");
        Assignment softDeleteAssignment = softDeleteMapping.createSoftDeleteAssignment(targetTableReference);
        UpdateStatement updateStatement = new UpdateStatement(targetTableReference, Collections.singletonList(softDeleteAssignment), softDeleteMapping.createNonDeletedRestriction(targetTableReference));
        return new TableDeleter(updateStatement, null, 0, entityDescriptor.getIdentifierMapping());
    }

    @Override
    public int execute(JdbcParameterBindings jdbcParameterBindings, DomainQueryExecutionContext executionContext) {
        List<Object> idsAndFks = MatchingIdSelectionHelper.selectMatchingIds(this.getMatchingIdsInterpretation(), jdbcParameterBindings, executionContext);
        if (idsAndFks == null || idsAndFks.isEmpty()) {
            return 0;
        }
        List<Expression> inListExpressions = this.getMatchingIdsPredicateProducer().produceIdExpressionList(idsAndFks, this.getEntityDescriptor());
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcMutationExecutor jdbcMutationExecutor = sessionFactory.getJdbcServices().getJdbcMutationExecutor();
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext);
        for (TableDeleter tableDeleter : this.tableDeleters) {
            jdbcMutationExecutor.execute(this.createMutation(tableDeleter, inListExpressions, executionContextAdapter), JdbcParameterBindings.NO_BINDINGS, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContextAdapter);
        }
        return idsAndFks.size();
    }

    protected JdbcOperationQueryMutation createMutation(TableDeleter tableDeleter, List<Expression> inListExpressions, ExecutionContext executionContext) {
        AbstractUpdateOrDeleteStatement statement;
        AbstractUpdateOrDeleteStatement abstractUpdateOrDeleteStatement = tableDeleter.statement;
        if (abstractUpdateOrDeleteStatement instanceof UpdateStatement) {
            UpdateStatement updateStatement = (UpdateStatement)abstractUpdateOrDeleteStatement;
            statement = new UpdateStatement(updateStatement, updateStatement.getTargetTable(), updateStatement.getFromClause(), updateStatement.getAssignments(), Predicate.combinePredicates(updateStatement.getRestriction(), this.getMatchingIdsPredicateProducer().produceRestriction(inListExpressions, this.getEntityDescriptor(), tableDeleter.valueIndex, tableDeleter.valueModelPart, updateStatement.getTargetTable(), tableDeleter.tableKeyColumnsVisitationSupplier, executionContext)), updateStatement.getReturningColumns());
        } else {
            DeleteStatement deleteStatement = (DeleteStatement)tableDeleter.statement;
            statement = new DeleteStatement(deleteStatement, deleteStatement.getTargetTable(), deleteStatement.getFromClause(), Predicate.combinePredicates(deleteStatement.getRestriction(), this.getMatchingIdsPredicateProducer().produceRestriction(inListExpressions, this.getEntityDescriptor(), tableDeleter.valueIndex, tableDeleter.valueModelPart, deleteStatement.getTargetTable(), tableDeleter.tableKeyColumnsVisitationSupplier, executionContext)), deleteStatement.getReturningColumns());
        }
        SessionFactoryImplementor sessionFactory = executionContext.getSession().getFactory();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
        return sqlAstTranslatorFactory.buildMutationTranslator(sessionFactory, statement).translate(JdbcParameterBindings.NO_BINDINGS, executionContext.getQueryOptions());
    }

    protected List<TableDeleter> getTableDeleters() {
        return this.tableDeleters;
    }

    protected record TableDeleter(AbstractUpdateOrDeleteStatement statement, @Nullable Supplier<Consumer<SelectableConsumer>> tableKeyColumnsVisitationSupplier, int valueIndex, @Nullable ModelPart valueModelPart) {
    }
}

