/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree;

import org.hibernate.query.common.JoinType;
import org.hibernate.sql.ast.SqlAstJoinType;

public enum SqmJoinType {
    INNER,
    LEFT,
    RIGHT,
    CROSS,
    FULL;


    public String toString() {
        return this.getText();
    }

    public String getText() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 2 -> "right outer";
            case 1 -> "left outer";
            case 0 -> "inner";
            case 4 -> "full";
            case 3 -> "cross";
        };
    }

    public SqlAstJoinType getCorrespondingSqlJoinType() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 2 -> SqlAstJoinType.RIGHT;
            case 1 -> SqlAstJoinType.LEFT;
            case 0 -> SqlAstJoinType.INNER;
            case 4 -> SqlAstJoinType.FULL;
            case 3 -> SqlAstJoinType.CROSS;
        };
    }

    public jakarta.persistence.criteria.JoinType getCorrespondingJpaJoinType() {
        return switch (this.ordinal()) {
            case 2 -> jakarta.persistence.criteria.JoinType.RIGHT;
            case 1 -> jakarta.persistence.criteria.JoinType.LEFT;
            case 0 -> jakarta.persistence.criteria.JoinType.INNER;
            default -> null;
        };
    }

    public JoinType getCorrespondingJoinType() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 2 -> JoinType.RIGHT;
            case 1 -> JoinType.LEFT;
            case 0 -> JoinType.INNER;
            case 4 -> JoinType.FULL;
            case 3 -> JoinType.CROSS;
        };
    }

    public static SqmJoinType from(JoinType joinType) {
        return switch (joinType) {
            default -> throw new IncompatibleClassChangeError();
            case JoinType.INNER -> INNER;
            case JoinType.LEFT -> LEFT;
            case JoinType.RIGHT -> RIGHT;
            case JoinType.CROSS -> CROSS;
            case JoinType.FULL -> FULL;
        };
    }

    public static SqmJoinType from(jakarta.persistence.criteria.JoinType jpaJoinType) {
        return switch (jpaJoinType) {
            default -> throw new IncompatibleClassChangeError();
            case jakarta.persistence.criteria.JoinType.INNER -> INNER;
            case jakarta.persistence.criteria.JoinType.LEFT -> LEFT;
            case jakarta.persistence.criteria.JoinType.RIGHT -> RIGHT;
        };
    }
}

