/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSession;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.Scope;

public abstract class BaseHttpServerRequest
implements HttpServerRequest {
    private final HttpExchangeSpi httpExchangeSpi;

    protected BaseHttpServerRequest(HttpExchangeSpi httpExchangeSpi) {
        this.httpExchangeSpi = httpExchangeSpi;
    }

    @Override
    public HttpScope getScope(Scope scope) {
        return this.httpExchangeSpi.getScope(scope);
    }

    @Override
    public Collection<String> getScopeIds(Scope scope) {
        return this.httpExchangeSpi.getScopeIds(scope);
    }

    @Override
    public HttpScope getScope(Scope scope, String id) {
        return this.httpExchangeSpi.getScope(scope, id);
    }

    @Override
    public List<String> getRequestHeaderValues(String headerName) {
        return this.httpExchangeSpi.getRequestHeaderValues(headerName);
    }

    @Override
    public String getFirstRequestHeaderValue(String headerName) {
        return this.httpExchangeSpi.getFirstRequestHeaderValue(headerName);
    }

    @Override
    public SSLSession getSSLSession() {
        return this.httpExchangeSpi.getSSLSession();
    }

    @Override
    public Certificate[] getPeerCertificates() {
        return this.httpExchangeSpi.getPeerCertificates(false);
    }

    @Override
    public String getRemoteUser() {
        return this.httpExchangeSpi.getRemoteUser();
    }

    @Override
    public String getRequestMethod() {
        return this.httpExchangeSpi.getRequestMethod();
    }

    @Override
    public URI getRequestURI() {
        return this.httpExchangeSpi.getRequestURI();
    }

    @Override
    public String getRequestPath() {
        return this.httpExchangeSpi.getRequestPath();
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return this.httpExchangeSpi.getRequestParameters();
    }

    @Override
    public Set<String> getParameterNames() {
        return this.httpExchangeSpi.getRequestParameterNames();
    }

    @Override
    public List<String> getParameterValues(String name) {
        return this.httpExchangeSpi.getRequestParameterValues(name);
    }

    @Override
    public String getFirstParameterValue(String name) {
        return this.httpExchangeSpi.getFirstRequestParameterValue(name);
    }

    @Override
    public List<HttpServerCookie> getCookies() {
        return this.httpExchangeSpi.getCookies();
    }

    @Override
    public InputStream getInputStream() {
        return this.httpExchangeSpi.getRequestInputStream();
    }

    @Override
    public InetSocketAddress getSourceAddress() {
        return this.httpExchangeSpi.getSourceAddress();
    }
}

