/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.credential.PasswordUserCredentialModel;

public class UserCredentialModel
implements CredentialInput {
    @Deprecated
    public static final String PASSWORD = "password";
    @Deprecated
    public static final String PASSWORD_HISTORY = "password-history";
    @Deprecated
    public static final String TOTP = "totp";
    @Deprecated
    public static final String HOTP = "hotp";
    @Deprecated
    public static final String PASSWORD_TOKEN = "password-token";
    public static final String SECRET = "secret";
    public static final String KERBEROS = "kerberos";
    public static final String CLIENT_CERT = "cert";
    private String credentialId;
    private String type;
    private String challengeResponse;
    private String device;
    private String algorithm;
    private boolean adminRequest;
    protected Map<String, Object> notes = new HashMap<String, Object>();

    public UserCredentialModel() {
    }

    public UserCredentialModel(String credentialId, String type, String challengeResponse) {
        this.credentialId = credentialId;
        this.type = type;
        this.challengeResponse = challengeResponse;
        this.adminRequest = false;
    }

    public UserCredentialModel(String credentialId, String type, String challengeResponse, boolean adminRequest) {
        this.credentialId = credentialId;
        this.type = type;
        this.challengeResponse = challengeResponse;
        this.adminRequest = adminRequest;
    }

    public static PasswordUserCredentialModel password(String password) {
        return UserCredentialModel.password(password, false);
    }

    public static PasswordUserCredentialModel password(String password, boolean adminRequest) {
        return new PasswordUserCredentialModel("", PASSWORD, password, adminRequest);
    }

    @Deprecated
    public static UserCredentialModel passwordToken(String passwordToken) {
        return new UserCredentialModel("", PASSWORD_TOKEN, passwordToken);
    }

    public static UserCredentialModel otp(String type, String key) {
        if (type.equals(HOTP)) {
            return UserCredentialModel.hotp(key);
        }
        if (type.equals(TOTP)) {
            return UserCredentialModel.totp(key);
        }
        throw new RuntimeException("Unknown OTP type");
    }

    public static UserCredentialModel totp(String key) {
        return new UserCredentialModel("", TOTP, key);
    }

    public static UserCredentialModel hotp(String key) {
        return new UserCredentialModel("", HOTP, key);
    }

    public static UserCredentialModel secret(String password) {
        return new UserCredentialModel("", SECRET, password);
    }

    public static UserCredentialModel kerberos(String token) {
        return new UserCredentialModel("", KERBEROS, token);
    }

    public static UserCredentialModel generateSecret() {
        return new UserCredentialModel("", SECRET, SecretGenerator.getInstance().randomString());
    }

    public static UserCredentialModel buildFromBackupAuthnCode(String backupAuthnCodeInput) {
        return UserCredentialModel.buildFromBackupAuthnCode("", backupAuthnCodeInput);
    }

    public static UserCredentialModel buildFromBackupAuthnCode(String credentialId, String backupAuthnCodeInput) {
        return new UserCredentialModel(credentialId, "recovery-authn-codes", backupAuthnCodeInput);
    }

    @Override
    public String getCredentialId() {
        return this.credentialId;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getChallengeResponse() {
        return this.challengeResponse;
    }

    public boolean isAdminRequest() {
        return this.adminRequest;
    }

    @Deprecated
    public static boolean isOtp(String type) {
        return TOTP.equals(type) || HOTP.equals(type);
    }

    public String getValue() {
        return this.getChallengeResponse();
    }

    public void setValue(String value) {
        this.challengeResponse = value;
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setNote(String key, Object value) {
        this.notes.put(key, value);
    }

    public void removeNote(String key) {
        this.notes.remove(key);
    }

    public Object getNote(String key) {
        return this.notes.get(key);
    }
}

