/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert;

import java.util.List;
import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public final class ExtendedKeyUsageExtension
extends X509CertificateExtension {
    private final List<String> keyPurposeIds;

    public ExtendedKeyUsageExtension(boolean critical, List<String> keyPurposeIds) {
        super(critical);
        Assert.checkNotNullParam((String)"keyPurposeIds", keyPurposeIds);
        Assert.checkNotEmptyParam((String)"keyPurposeIds", keyPurposeIds);
        this.keyPurposeIds = keyPurposeIds;
    }

    @Override
    public String getId() {
        return "2.5.29.37";
    }

    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        for (String keyPurposeId : this.keyPurposeIds) {
            encoder.encodeObjectIdentifier(keyPurposeId);
        }
        encoder.endSequence();
    }
}

