/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.logging.DeprecatedMessage;
import org.opensearch.common.logging.HeaderWarning;

@PublicApi(since="1.0.0")
public class DeprecationLogger {
    public static Level DEPRECATION = Level.forName((String)"DEPRECATION", (int)(Level.WARN.intLevel() + 1));
    private final Logger logger;

    private DeprecationLogger(Logger parentLogger) {
        this.logger = parentLogger;
    }

    public static DeprecationLogger getLogger(Class<?> aClass) {
        return DeprecationLogger.getLogger(DeprecationLogger.toLoggerName(aClass));
    }

    public static DeprecationLogger getLogger(String name) {
        return new DeprecationLogger(DeprecationLogger.getDeprecatedLoggerForName(name));
    }

    private static Logger getDeprecatedLoggerForName(String name) {
        name = ((String)name).startsWith("org.opensearch") ? ((String)name).replace("org.opensearch.", "org.opensearch.deprecation.") : "deprecation." + (String)name;
        return LogManager.getLogger((String)name);
    }

    private static String toLoggerName(Class<?> cls) {
        String canonicalName = cls.getCanonicalName();
        return canonicalName != null ? canonicalName : cls.getName();
    }

    public DeprecationLoggerBuilder deprecate(String key, String msg, Object ... params) {
        return new DeprecationLoggerBuilder().withDeprecation(key, msg, params);
    }

    @PublicApi(since="1.0.0")
    public class DeprecationLoggerBuilder {
        public DeprecationLoggerBuilder withDeprecation(String key, String msg, Object[] params) {
            DeprecatedMessage deprecationMessage;
            if (DeprecationLogger.this.logger.isEnabled(DEPRECATION) && !(deprecationMessage = new DeprecatedMessage(key, HeaderWarning.getXOpaqueId(), msg, params)).isAlreadyLogged()) {
                DeprecationLogger.this.logger.log(DEPRECATION, (Message)deprecationMessage);
            }
            return this;
        }
    }
}

