/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.usage;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeUsage
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeUsage> {
    @Nonnull
    private final Map<String, JsonData> aggregations;
    @Nonnull
    private final Map<String, Long> restActions;
    private final long since;
    private final long timestamp;
    public static final JsonpDeserializer<NodeUsage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeUsage::setupNodeUsageDeserializer);

    private NodeUsage(Builder builder) {
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.restActions = ApiTypeHelper.unmodifiable(builder.restActions);
        this.since = ApiTypeHelper.requireNonNull(builder.since, this, "since");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
    }

    public static NodeUsage of(Function<Builder, ObjectBuilder<NodeUsage>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, JsonData> aggregations() {
        return this.aggregations;
    }

    @Nonnull
    public final Map<String, Long> restActions() {
        return this.restActions;
    }

    public final long since() {
        return this.since;
    }

    public final long timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.restActions)) {
            generator.writeKey("rest_actions");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.restActions.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(((Long)entry.getValue()).longValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("since");
        generator.write(this.since);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeUsageDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "aggregations");
        op.add(Builder::restActions, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "rest_actions");
        op.add(Builder::since, JsonpDeserializer.longDeserializer(), "since");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.aggregations);
        result = 31 * result + Objects.hashCode(this.restActions);
        result = 31 * result + Long.hashCode(this.since);
        result = 31 * result + Long.hashCode(this.timestamp);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeUsage other = (NodeUsage)o;
        return Objects.equals(this.aggregations, other.aggregations) && Objects.equals(this.restActions, other.restActions) && this.since == other.since && this.timestamp == other.timestamp;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeUsage> {
        @Nullable
        private Map<String, JsonData> aggregations;
        @Nullable
        private Map<String, Long> restActions;
        private Long since;
        private Long timestamp;

        public Builder() {
        }

        private Builder(NodeUsage o) {
            this.aggregations = Builder._mapCopy(o.aggregations);
            this.restActions = Builder._mapCopy(o.restActions);
            this.since = o.since;
            this.timestamp = o.timestamp;
        }

        private Builder(Builder o) {
            this.aggregations = Builder._mapCopy(o.aggregations);
            this.restActions = Builder._mapCopy(o.restActions);
            this.since = o.since;
            this.timestamp = o.timestamp;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder aggregations(Map<String, JsonData> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        @Nonnull
        public final Builder aggregations(String key, JsonData value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        @Nonnull
        public final Builder restActions(Map<String, Long> map) {
            this.restActions = Builder._mapPutAll(this.restActions, map);
            return this;
        }

        @Nonnull
        public final Builder restActions(String key, Long value) {
            this.restActions = Builder._mapPut(this.restActions, key, value);
            return this;
        }

        @Nonnull
        public final Builder since(long value) {
            this.since = value;
            return this;
        }

        @Nonnull
        public final Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        @Override
        @Nonnull
        public NodeUsage build() {
            this._checkSingleUse();
            return new NodeUsage(this);
        }
    }
}

