/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.JsonbException;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Type;
import org.eclipse.yasson.internal.components.AdapterBinding;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractContainerDeserializer;
import org.eclipse.yasson.internal.serializer.CurrentItem;

public class AdaptedObjectDeserializer<A, T>
implements CurrentItem<T>,
JsonbDeserializer<T> {
    private JsonbDeserializer<A> adaptedTypeDeserializer;
    private final AdapterBinding adapterInfo;
    private final AbstractContainerDeserializer<?> wrapperItem;

    public AdaptedObjectDeserializer(AdapterBinding adapterInfo, AbstractContainerDeserializer<?> wrapperItem) {
        this.adapterInfo = adapterInfo;
        this.wrapperItem = wrapperItem;
    }

    @Override
    public ClassModel getClassModel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CurrentItem<?> getWrapper() {
        return this.wrapperItem;
    }

    @Override
    public Type getRuntimeType() {
        if (this.adaptedTypeDeserializer instanceof AbstractContainerDeserializer) {
            return ((AbstractContainerDeserializer)this.adaptedTypeDeserializer).getRuntimeType();
        }
        throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, "Deserialization propagation is not allowed for:" + this.adaptedTypeDeserializer));
    }

    public void setAdaptedTypeDeserializer(JsonbDeserializer<A> adaptedTypeDeserializer) {
        this.adaptedTypeDeserializer = adaptedTypeDeserializer;
    }

    public T deserialize(JsonParser parser, DeserializationContext context, Type rtType) {
        try {
            Object result = this.adaptedTypeDeserializer.deserialize(parser, context, rtType);
            Object adapted = this.adapterInfo.getAdapter().adaptFromJson(result);
            return (T)adapted;
        }
        catch (Exception e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.ADAPTER_EXCEPTION, this.adapterInfo.getBindingType(), this.adapterInfo.getToType(), this.adapterInfo.getAdapter().getClass()), (Throwable)e);
        }
    }
}

