/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.List;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;
import org.apache.hadoop.hdfs.util.LongBitFormat;

public enum AclEntryStatusFormat implements LongBitFormat.Enum
{
    PERMISSION(null, 3),
    TYPE(AclEntryStatusFormat.PERMISSION.BITS, 2),
    SCOPE(AclEntryStatusFormat.TYPE.BITS, 1),
    NAME(AclEntryStatusFormat.SCOPE.BITS, 24);

    private static final FsAction[] FSACTION_VALUES;
    private static final AclEntryScope[] ACL_ENTRY_SCOPE_VALUES;
    private static final AclEntryType[] ACL_ENTRY_TYPE_VALUES;
    private final LongBitFormat BITS;

    private AclEntryStatusFormat(LongBitFormat previous, int length) {
        this.BITS = new LongBitFormat(this.name(), previous, length, 0L);
    }

    static AclEntryScope getScope(int aclEntry) {
        int ordinal = (int)AclEntryStatusFormat.SCOPE.BITS.retrieve((long)aclEntry);
        return ACL_ENTRY_SCOPE_VALUES[ordinal];
    }

    static AclEntryType getType(int aclEntry) {
        int ordinal = (int)AclEntryStatusFormat.TYPE.BITS.retrieve((long)aclEntry);
        return ACL_ENTRY_TYPE_VALUES[ordinal];
    }

    static FsAction getPermission(int aclEntry) {
        int ordinal = (int)AclEntryStatusFormat.PERMISSION.BITS.retrieve((long)aclEntry);
        return FSACTION_VALUES[ordinal];
    }

    static String getName(int aclEntry) {
        return AclEntryStatusFormat.getName(aclEntry, null);
    }

    static String getName(int aclEntry, SerialNumberManager.StringTable stringTable) {
        SerialNumberManager snm = AclEntryStatusFormat.getSerialNumberManager(AclEntryStatusFormat.getType(aclEntry));
        if (snm != null) {
            int nid = (int)AclEntryStatusFormat.NAME.BITS.retrieve((long)aclEntry);
            return snm.getString(nid, stringTable);
        }
        return null;
    }

    static int toInt(AclEntry aclEntry) {
        long aclEntryInt = 0L;
        aclEntryInt = AclEntryStatusFormat.SCOPE.BITS.combine((long)aclEntry.getScope().ordinal(), aclEntryInt);
        aclEntryInt = AclEntryStatusFormat.TYPE.BITS.combine((long)aclEntry.getType().ordinal(), aclEntryInt);
        aclEntryInt = AclEntryStatusFormat.PERMISSION.BITS.combine((long)aclEntry.getPermission().ordinal(), aclEntryInt);
        SerialNumberManager snm = AclEntryStatusFormat.getSerialNumberManager(aclEntry.getType());
        if (snm != null) {
            int nid = snm.getSerialNumber(aclEntry.getName());
            aclEntryInt = AclEntryStatusFormat.NAME.BITS.combine((long)nid, aclEntryInt);
        }
        return (int)aclEntryInt;
    }

    static AclEntry toAclEntry(int aclEntry) {
        return AclEntryStatusFormat.toAclEntry(aclEntry, null);
    }

    static AclEntry toAclEntry(int aclEntry, SerialNumberManager.StringTable stringTable) {
        return new AclEntry.Builder().setScope(AclEntryStatusFormat.getScope(aclEntry)).setType(AclEntryStatusFormat.getType(aclEntry)).setPermission(AclEntryStatusFormat.getPermission(aclEntry)).setName(AclEntryStatusFormat.getName(aclEntry, stringTable)).build();
    }

    public static int[] toInt(List<AclEntry> aclEntries) {
        int[] entries = new int[aclEntries.size()];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = AclEntryStatusFormat.toInt(aclEntries.get(i));
        }
        return entries;
    }

    private static SerialNumberManager getSerialNumberManager(AclEntryType type) {
        switch (type) {
            case USER: {
                return SerialNumberManager.USER;
            }
            case GROUP: {
                return SerialNumberManager.GROUP;
            }
        }
        return null;
    }

    public int getLength() {
        return this.BITS.getLength();
    }

    static {
        FSACTION_VALUES = FsAction.values();
        ACL_ENTRY_SCOPE_VALUES = AclEntryScope.values();
        ACL_ENTRY_TYPE_VALUES = AclEntryType.values();
    }
}

