/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.schema.TableTypes;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.IdentifiersBuilder;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.utility.TypeMap;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.DatabaseServerType;

public final class SchemaRetrievalOptionsBuilder
implements OptionsBuilder<SchemaRetrievalOptionsBuilder, SchemaRetrievalOptions> {
    DatabaseServerType dbServerType = DatabaseServerType.UNKNOWN;
    String identifierQuoteString = "";
    Identifiers identifiers;
    InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.newInformationSchemaViews();
    Optional<Boolean> overridesSupportsSchemas = Optional.empty();
    Optional<Boolean> overridesSupportsCatalogs = Optional.empty();
    Optional<TypeMap> overridesTypeMap;
    TableTypes tableTypes;
    boolean supportsCatalogs = true;
    boolean supportsSchemas = true;
    EnumDataTypeHelper enumDataTypeHelper;
    Map<SchemaInfoMetadataRetrievalStrategy, MetadataRetrievalStrategy> metadataRetrievalStrategyMap;
    Consumer<Connection> connectionInitializer;

    public static SchemaRetrievalOptionsBuilder builder() {
        return new SchemaRetrievalOptionsBuilder();
    }

    public static SchemaRetrievalOptionsBuilder builder(SchemaRetrievalOptions options) {
        return new SchemaRetrievalOptionsBuilder().fromOptions(options);
    }

    public static SchemaRetrievalOptions newSchemaRetrievalOptions() {
        return new SchemaRetrievalOptionsBuilder().toOptions();
    }

    private SchemaRetrievalOptionsBuilder() {
        this.identifiers = Identifiers.STANDARD;
        this.overridesTypeMap = Optional.empty();
        this.tableTypes = TableTypes.from("TABLE", "VIEW", "SYSTEM TABLE", "GLOBAL TEMPORARY", "LOCAL TEMPORARY");
        this.enumDataTypeHelper = EnumDataTypeHelper.NO_OP_ENUM_DATA_TYPE_HELPER;
        this.connectionInitializer = connection -> {};
        this.metadataRetrievalStrategyMap = new EnumMap<SchemaInfoMetadataRetrievalStrategy, MetadataRetrievalStrategy>(SchemaInfoMetadataRetrievalStrategy.class);
        for (SchemaInfoMetadataRetrievalStrategy key : SchemaInfoMetadataRetrievalStrategy.values()) {
            this.metadataRetrievalStrategyMap.put(key, MetadataRetrievalStrategy.metadata);
        }
    }

    public SchemaRetrievalOptionsBuilder fromConnnection(Connection connection) {
        DatabaseMetaData metaData;
        if (connection == null) {
            return this;
        }
        try {
            metaData = connection.getMetaData();
        }
        catch (SQLException e) {
            metaData = null;
        }
        this.identifierQuoteString = this.lookupIdentifierQuoteString(metaData);
        this.identifiers = IdentifiersBuilder.builder().fromConnection(connection).withIdentifierQuoteString(this.identifierQuoteString).toOptions();
        this.supportsCatalogs = this.lookupSupportsCatalogs(metaData);
        this.supportsSchemas = this.lookupSupportsSchemas(metaData);
        if (this.overridesTypeMap.isEmpty()) {
            this.overridesTypeMap = Optional.of(new TypeMap(connection));
        }
        this.tableTypes = TableTypes.from(connection);
        return this;
    }

    public SchemaRetrievalOptionsBuilder fromOptions(SchemaRetrievalOptions options) {
        if (options == null) {
            return this;
        }
        this.dbServerType = options.getDatabaseServerType();
        this.informationSchemaViews = options.getInformationSchemaViews();
        this.overridesSupportsSchemas = Optional.empty();
        this.overridesSupportsCatalogs = Optional.empty();
        this.supportsCatalogs = options.isSupportsCatalogs();
        this.supportsSchemas = options.isSupportsSchemas();
        this.identifierQuoteString = options.getIdentifierQuoteString();
        this.identifiers = options.getIdentifiers();
        this.overridesTypeMap = Optional.empty();
        this.metadataRetrievalStrategyMap = options.getMetadataRetrievalStrategyMap();
        this.connectionInitializer = options.getConnectionInitializer();
        return this;
    }

    public MetadataRetrievalStrategy get(SchemaInfoMetadataRetrievalStrategy schemaInfoMetadataRetrievalStrategy) {
        if (schemaInfoMetadataRetrievalStrategy != null) {
            return this.metadataRetrievalStrategyMap.get((Object)schemaInfoMetadataRetrievalStrategy);
        }
        return null;
    }

    public InformationSchemaViews getInformationSchemaViews() {
        return this.informationSchemaViews;
    }

    @Override
    public SchemaRetrievalOptions toOptions() {
        return new SchemaRetrievalOptions(this);
    }

    public SchemaRetrievalOptionsBuilder with(SchemaInfoMetadataRetrievalStrategy schemaInfoMetadataRetrievalStrategy, MetadataRetrievalStrategy metadataRetrievalStrategy) {
        if (schemaInfoMetadataRetrievalStrategy == null) {
            return this;
        }
        if (metadataRetrievalStrategy == null) {
            this.metadataRetrievalStrategyMap.put(schemaInfoMetadataRetrievalStrategy, MetadataRetrievalStrategy.metadata);
        } else {
            this.metadataRetrievalStrategyMap.put(schemaInfoMetadataRetrievalStrategy, metadataRetrievalStrategy);
        }
        return this;
    }

    public SchemaRetrievalOptionsBuilder withConnectionInitializer(Consumer<Connection> connectionInitializer) {
        this.connectionInitializer = connectionInitializer == null ? connection -> {} : connectionInitializer;
        return this;
    }

    public SchemaRetrievalOptionsBuilder withDatabaseServerType(DatabaseServerType dbServerType) {
        this.dbServerType = dbServerType == null ? DatabaseServerType.UNKNOWN : dbServerType;
        return this;
    }

    public SchemaRetrievalOptionsBuilder withDoesNotSupportCatalogs() {
        this.overridesSupportsCatalogs = Optional.of(false);
        return this;
    }

    public SchemaRetrievalOptionsBuilder withDoesNotSupportSchemas() {
        this.overridesSupportsSchemas = Optional.of(false);
        return this;
    }

    public SchemaRetrievalOptionsBuilder withEnumDataTypeHelper(EnumDataTypeHelper enumDataTypeHelper) {
        this.enumDataTypeHelper = enumDataTypeHelper != null ? enumDataTypeHelper : EnumDataTypeHelper.NO_OP_ENUM_DATA_TYPE_HELPER;
        return this;
    }

    public SchemaRetrievalOptionsBuilder withIdentifierQuoteString(String identifierQuoteString) {
        this.identifierQuoteString = Utility.isBlank(identifierQuoteString) ? "" : identifierQuoteString;
        return this;
    }

    public SchemaRetrievalOptionsBuilder withInformationSchemaViews(InformationSchemaViews informationSchemaViews) {
        this.informationSchemaViews = InformationSchemaViewsBuilder.builder().fromOptions(informationSchemaViews).toOptions();
        return this;
    }

    public SchemaRetrievalOptionsBuilder withoutIdentifierQuoteString() {
        this.identifierQuoteString = "";
        return this;
    }

    public SchemaRetrievalOptionsBuilder withoutSupportsCatalogs() {
        this.overridesSupportsCatalogs = Optional.empty();
        return this;
    }

    public SchemaRetrievalOptionsBuilder withoutSupportsSchemas() {
        this.overridesSupportsSchemas = Optional.empty();
        return this;
    }

    public SchemaRetrievalOptionsBuilder withSupportsCatalogs() {
        this.overridesSupportsCatalogs = Optional.of(true);
        return this;
    }

    public SchemaRetrievalOptionsBuilder withSupportsSchemas() {
        this.overridesSupportsSchemas = Optional.of(true);
        return this;
    }

    public SchemaRetrievalOptionsBuilder withTypeMap(Map<String, Class<?>> typeMap) {
        this.overridesTypeMap = typeMap == null ? Optional.empty() : Optional.of(new TypeMap(typeMap));
        return this;
    }

    private String lookupIdentifierQuoteString(DatabaseMetaData metaData) {
        String identifierQuoteString = "\"";
        if (!Utility.isBlank(this.identifierQuoteString)) {
            identifierQuoteString = this.identifierQuoteString;
        } else if (metaData != null) {
            try {
                identifierQuoteString = metaData.getIdentifierQuoteString();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return Utility.trimToEmpty(identifierQuoteString);
    }

    private boolean lookupSupportsCatalogs(DatabaseMetaData metaData) {
        boolean supportsCatalogs = true;
        if (this.overridesSupportsCatalogs.isPresent()) {
            supportsCatalogs = this.overridesSupportsCatalogs.get();
        } else if (metaData != null) {
            try {
                supportsCatalogs = metaData.supportsCatalogsInTableDefinitions();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return supportsCatalogs;
    }

    private boolean lookupSupportsSchemas(DatabaseMetaData metaData) {
        boolean supportsSchemas = true;
        if (this.overridesSupportsSchemas.isPresent()) {
            supportsSchemas = this.overridesSupportsSchemas.get();
        } else if (metaData != null) {
            try {
                supportsSchemas = metaData.supportsSchemasInTableDefinitions();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return supportsSchemas;
    }
}

