/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.pickle;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.pickle.PPickler;
import com.oracle.graal.python.builtins.modules.pickle.PUnpickler;
import com.oracle.graal.python.builtins.modules.pickle.PickleModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.pickle.PickleModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.pickle.PickleState;
import com.oracle.graal.python.builtins.modules.pickle.PickleStateFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_pickle")
public final class PickleModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PickleModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PickleState state = new PickleState();
        PickleState.PickleStateInitNode initNode = PickleStateFactory.PickleStateInitNodeGen.getUncached();
        initNode.execute(state);
        HiddenAttr.WriteNode.executeUncached(core.lookupType(PythonBuiltinClassType.Pickler), HiddenAttr.PICKLE_STATE, state);
    }

    @Builtin(name="loads", minNumOfPositionalArgs=2, declaresExplicitSelf=true, parameterNames={"$self", "data"}, keywordOnlyNames={"fix_imports", "encoding", "errors", "buffers"})
    @ArgumentsClinic(value={@ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="fix_imports", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true"), @ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_ASCII_UPPERCASE"), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT")})
    @GenerateNodeFactory
    static abstract class PickleLoadsNode
    extends PythonClinicBuiltinNode {
        PickleLoadsNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PickleModuleBuiltinsClinicProviders.PickleLoadsNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static Object loads(VirtualFrame frame, PythonModule self, Object buffer, boolean fixImports, TruffleString encoding, TruffleString errors, Object buffers, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached PUnpickler.LoadNode loadNode, @Cached PyObjectGetIter getIter) {
            try {
                PUnpickler unpickler = PFactory.createUnpickler(language);
                byte[] data = bufferLib.getCopiedByteArray(buffer);
                unpickler.setStringInput(data, data.length);
                unpickler.setInputEncoding(encoding, errors);
                unpickler.setBuffers(frame, inliningTarget, getIter, buffers);
                unpickler.setFixImports(fixImports);
                Object object = loadNode.execute(frame, unpickler);
                return object;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }
    }

    @Builtin(name="load", minNumOfPositionalArgs=2, declaresExplicitSelf=true, parameterNames={"$self", "file"}, keywordOnlyNames={"fix_imports", "encoding", "errors", "buffers"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fix_imports", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true"), @ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_ASCII_UPPERCASE"), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT")})
    @GenerateNodeFactory
    static abstract class PickleLoadNode
    extends PythonClinicBuiltinNode {
        PickleLoadNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PickleModuleBuiltinsClinicProviders.PickleLoadNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object load(VirtualFrame frame, PythonModule self, Object file, boolean fixImports, TruffleString encoding, TruffleString errors, Object buffers, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached PUnpickler.LoadNode loadNode, @Cached PyObjectLookupAttr lookup, @Cached PyObjectGetIter getIter, @Cached PRaiseNode raiseNode) {
            PUnpickler unpickler = PFactory.createUnpickler(language);
            unpickler.setInputStream(frame, inliningTarget, raiseNode, lookup, file);
            unpickler.setInputEncoding(encoding, errors);
            unpickler.setBuffers(frame, inliningTarget, getIter, buffers);
            return loadNode.execute(frame, unpickler);
        }
    }

    @Builtin(name="dumps", minNumOfPositionalArgs=2, declaresExplicitSelf=true, parameterNames={"$self", "obj", "protocol"}, keywordOnlyNames={"fix_imports", "buffer_callback"})
    @ArgumentsClinic(value={@ArgumentClinic(name="protocol", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="4", useDefaultForNone=true), @ArgumentClinic(name="fix_imports", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    static abstract class PickleDumpsNode
    extends PythonClinicBuiltinNode {
        PickleDumpsNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PickleModuleBuiltinsClinicProviders.PickleDumpsNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object dump(VirtualFrame frame, PythonModule self, Object obj, int protocol, boolean fixImports, Object bufferCallback, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached PPickler.DumpNode dumpNode, @Cached PRaiseNode raiseNode) {
            PPickler pickler = PFactory.createPickler(language);
            pickler.setProtocol(inliningTarget, raiseNode, protocol, fixImports);
            pickler.setBufferCallback(inliningTarget, raiseNode, bufferCallback);
            dumpNode.execute(frame, pickler, obj);
            return pickler.getString(language);
        }
    }

    @Builtin(name="dump", minNumOfPositionalArgs=3, declaresExplicitSelf=true, parameterNames={"$self", "obj", "file", "protocol"}, keywordOnlyNames={"fix_imports", "buffer_callback"})
    @ArgumentsClinic(value={@ArgumentClinic(name="protocol", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="4", useDefaultForNone=true), @ArgumentClinic(name="fix_imports", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    static abstract class PickleDumpNode
    extends PythonClinicBuiltinNode {
        PickleDumpNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PickleModuleBuiltinsClinicProviders.PickleDumpNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object dump(VirtualFrame frame, PythonModule self, Object obj, Object file, int protocol, boolean fixImports, Object bufferCallback, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached PPickler.DumpNode dumpNode, @Cached PPickler.FlushToFileNode flushToFileNode, @Cached PyObjectLookupAttr lookup, @Cached PRaiseNode raiseNode) {
            PPickler pickler = PFactory.createPickler(language);
            pickler.setProtocol(inliningTarget, raiseNode, protocol, fixImports);
            pickler.setOutputStream(frame, inliningTarget, raiseNode, lookup, file);
            pickler.setBufferCallback(inliningTarget, raiseNode, bufferCallback);
            dumpNode.execute(frame, pickler, obj);
            flushToFileNode.execute(frame, pickler);
            return PNone.NONE;
        }
    }
}

