/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rdr;

import com.tigervnc.rdr.AESEAXCipher;
import com.tigervnc.rdr.Exception;
import com.tigervnc.rdr.InStream;
import java.nio.ByteBuffer;

public class AESInStream
extends InStream {
    private static final int maxMessageSize = 65536;
    private AESEAXCipher cipher;
    private int offset;
    private int start;
    private int bufSize;
    private int state;
    private int messageSize;
    private int messageOffset;
    private byte[] message;
    private int decryptedMessageOffset;
    private byte[] decryptedMessage;
    private byte[] counter;
    private InStream in;

    public AESInStream(InStream inStream, byte[] byArray) {
        this.in = inStream;
        this.offset = 0;
        this.bufSize = 65536;
        this.b = new byte[this.bufSize];
        this.start = 0;
        this.end = 0;
        this.ptr = 0;
        this.cipher = new AESEAXCipher(byArray);
        this.messageSize = 0;
        this.messageOffset = 0;
        this.message = new byte[65552];
        this.decryptedMessageOffset = 0;
        this.decryptedMessage = new byte[65536];
        this.counter = new byte[16];
        this.state = 0;
    }

    @Override
    public final int pos() {
        return this.offset + this.ptr - this.start;
    }

    @Override
    protected final int overrun(int n, int n2, boolean bl) {
        int n3;
        if (n > this.bufSize) {
            throw new Exception("AESInStream overrun: max itemSize exceeded");
        }
        if (this.end - this.ptr != 0) {
            System.arraycopy(this.b, this.ptr, this.b, 0, this.end - this.ptr);
        }
        this.offset += this.ptr - this.start;
        this.end -= this.ptr - this.start;
        this.ptr = this.start;
        while (this.end - this.start < n) {
            n3 = this.readMessage(this.b, this.end, this.start + this.bufSize - this.end, bl);
            if (!bl && n3 == 0) {
                return 0;
            }
            this.end += n3;
        }
        n3 = (this.end - this.ptr) / n;
        if (n3 < n2) {
            return n3;
        }
        return n2;
    }

    private int readMessage(byte[] byArray, int n, int n2, boolean bl) {
        if (!(this.state != 0 && this.state != 1 || this.fillDecryptedMessageBuffer(bl) || bl)) {
            return 0;
        }
        if (this.state == 2) {
            int n3 = this.messageSize - this.decryptedMessageOffset;
            if (n3 > n2) {
                n3 = n2;
            }
            System.arraycopy(this.decryptedMessage, this.decryptedMessageOffset, byArray, n, n3);
            this.decryptedMessageOffset += n3;
            if (this.decryptedMessageOffset == this.messageSize) {
                this.state = 0;
            }
            return n3;
        }
        return 0;
    }

    private boolean fillDecryptedMessageBuffer(boolean bl) {
        int n;
        block9: {
            block8: {
                if (this.state == 0) {
                    do {
                        if (this.in.check(2, 1, bl) == 0) continue;
                        this.messageSize = this.in.readU16();
                        this.messageOffset = 0;
                        this.state = 1;
                        break block8;
                    } while (bl);
                    return false;
                }
            }
            if (this.state == 1) {
                if (bl) {
                    this.in.readBytes(ByteBuffer.wrap(this.message, this.messageOffset, this.messageSize + 16 - this.messageOffset), this.messageSize + 16 - this.messageOffset);
                } else {
                    int n2;
                    while (this.in.check(1, n2 = this.messageSize + 16 - this.messageOffset, false) != 0) {
                        n = this.in.getend() - this.in.getptr();
                        if (n2 > n) {
                            n2 = n;
                        }
                        this.in.readBytes(ByteBuffer.wrap(this.message, this.messageOffset, n2), n2);
                        this.messageOffset += n2;
                        if (this.messageSize + 16 != this.messageOffset) continue;
                        break block9;
                    }
                    return false;
                }
            }
        }
        byte[] byArray = new byte[]{(byte)((this.messageSize & 0xFF00) >> 8), (byte)(this.messageSize & 0xFF)};
        this.cipher.decrypt(this.message, 0, this.messageSize, byArray, 0, 2, this.counter, this.decryptedMessage, 0, this.message, this.messageSize);
        n = 0;
        while (n < 16) {
            int n3 = n++;
            this.counter[n3] = (byte)(this.counter[n3] + 1);
            if (this.counter[n3] != 0) break;
        }
        this.decryptedMessageOffset = 0;
        this.state = 2;
        return true;
    }
}

