/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.sampler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.core.ui.components.Spacer;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.views.components.MessageComponent;
import org.graalvm.visualvm.jfr.views.sampler.JFRSnapshotSamplerViewProvider;
import org.graalvm.visualvm.lib.ui.components.HTMLLabel;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

final class SamplerViewSupport {
    SamplerViewSupport() {
    }

    static final class SummaryViewSupport
    extends JPanel {
        SummaryViewSupport(JFRModel model) {
            super(new BorderLayout());
            HTMLTextArea summaryArea = new HTMLTextArea(this.getSummary(model));
            summaryArea.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add((Component)summaryArea, "Center");
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(SamplerViewSupport.class, (String)"LBL_Summary"), null, 10, (JComponent)new ScrollableContainer((JComponent)this), null);
        }

        private String getSummary(JFRModel model) {
            StringBuilder builder = new StringBuilder();
            SummaryViewSupport.addCpuHeader(builder);
            builder.append("CPU samples ");
            builder.append("available.");
            builder.append(" ");
            builder.append("Thread CPU load ");
            builder.append(model.containsEvent(JFRSnapshotSamplerViewProvider.ThreadCPUChecker.class) ? "available." : "not recorded.");
            SummaryViewSupport.addMemoryHeader(builder);
            builder.append("Heap histogram ");
            builder.append(model.containsEvent(JFRSnapshotSamplerViewProvider.ObjectCountChecker.class) ? "available." : "not recorded.");
            builder.append(" ");
            builder.append("Per thread allocations ");
            builder.append(model.containsEvent(JFRSnapshotSamplerViewProvider.ThreadAllocationsChecker.class) ? "available." : "not recorded.");
            return builder.toString();
        }

        private static void addCpuHeader(StringBuilder builder) {
            builder.append(NbBundle.getMessage(SamplerViewSupport.class, (String)"LBL_Cpu_sampling"));
        }

        private static void addMemoryHeader(StringBuilder builder) {
            builder.append(NbBundle.getMessage(SamplerViewSupport.class, (String)"LBL_Memory_sampling"));
        }
    }

    static abstract class MasterViewSupport
    extends JPanel {
        private JLabel modeLabel;
        private JToggleButton cpuButton;
        private JToggleButton memoryButton;
        private HTMLLabel statusValueLabel;

        MasterViewSupport(JFRModel model) {
            this.initComponents(model);
        }

        DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(SamplerViewSupport.class, (String)"LBL_Sampler"), null, (JComponent)this);
        }

        abstract void showCPU();

        abstract void showMemory();

        void showProgress() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    statusValueLabel.setVisible(true);
                    cpuButton.setEnabled(false);
                    memoryButton.setEnabled(false);
                }
            });
        }

        void hideProgress() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    statusValueLabel.setVisible(false);
                    cpuButton.setEnabled(true);
                    memoryButton.setEnabled(true);
                }
            });
        }

        private void handleCPUData() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    memoryButton.setSelected(false);
                    this.showCPU();
                }
            });
        }

        private void handleMemoryData() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    cpuButton.setSelected(false);
                    this.showMemory();
                }
            });
        }

        private void initComponents(JFRModel model) {
            this.setOpaque(false);
            if (model == null) {
                this.setLayout(new BorderLayout());
                this.add((Component)MessageComponent.notAvailable(), "Center");
            } else {
                this.setLayout(new GridBagLayout());
                this.setBorder(BorderFactory.createEmptyBorder(11, 5, 20, 5));
                this.modeLabel = new JLabel(NbBundle.getMessage(SamplerViewSupport.class, (String)"LBL_Profile"));
                this.modeLabel.setFont(this.modeLabel.getFont().deriveFont(1));
                Dimension d = this.modeLabel.getPreferredSize();
                this.modeLabel.setText(NbBundle.getMessage(SamplerViewSupport.class, (String)"LBL_Sample"));
                d.width = Math.max(d.width, this.modeLabel.getPreferredSize().width);
                this.modeLabel.setPreferredSize(d);
                this.modeLabel.setOpaque(false);
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.gridx = 0;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 8, 0, 0);
                this.add((Component)this.modeLabel, constraints);
                this.cpuButton = new OneWayToggleButton(NbBundle.getMessage(SamplerViewSupport.class, (String)"LBL_Cpu"));
                this.cpuButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/sampler/resources/cpu.png", (boolean)true)));
                this.cpuButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.handleCPUData();
                    }
                });
                constraints = new GridBagConstraints();
                constraints.gridx = 2;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 8, 0, 0);
                this.add((Component)this.cpuButton, constraints);
                this.memoryButton = new OneWayToggleButton(NbBundle.getMessage(SamplerViewSupport.class, (String)"LBL_Memory"));
                this.memoryButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/sampler/resources/memory.png", (boolean)true)));
                this.memoryButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.handleMemoryData();
                    }
                });
                constraints = new GridBagConstraints();
                constraints.gridx = 3;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 8, 0, 0);
                this.add((Component)this.memoryButton, constraints);
                this.statusValueLabel = new HTMLLabel("<nobr><b>Progress:</b> reading data...</nobr>");
                constraints = new GridBagConstraints();
                constraints.gridx = 4;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 20, 0, 0);
                this.add((Component)this.statusValueLabel, constraints);
                this.statusValueLabel.setVisible(false);
                constraints = new GridBagConstraints();
                constraints.gridx = 5;
                constraints.gridy = 2;
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.gridwidth = 0;
                constraints.fill = 1;
                constraints.anchor = 18;
                constraints.insets = new Insets(0, 0, 0, 0);
                this.add((Component)Spacer.create(), constraints);
                Dimension cpuD = this.cpuButton.getPreferredSize();
                Dimension memoryD = this.memoryButton.getPreferredSize();
                Dimension maxD = new Dimension(Math.max(cpuD.width, memoryD.width), Math.max(cpuD.height, memoryD.height));
                this.cpuButton.setPreferredSize(maxD);
                this.cpuButton.setMinimumSize(maxD);
                this.memoryButton.setPreferredSize(maxD);
                this.memoryButton.setMinimumSize(maxD);
            }
        }

        private static final class OneWayToggleButton
        extends JToggleButton {
            OneWayToggleButton(String text) {
                super(text);
            }

            @Override
            protected void processMouseEvent(MouseEvent e) {
                if (!this.isSelected() || 505 == e.getID()) {
                    super.processMouseEvent(e);
                }
            }

            @Override
            protected void processKeyEvent(KeyEvent e) {
                if (!this.isSelected()) {
                    super.processKeyEvent(e);
                }
            }
        }
    }
}

