﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/backupsearch/BackupSearch_EXPORTS.h>
#include <aws/core/utils/DateTime.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BackupSearch {
namespace Model {

/**
 * <p>This filters by recovery points within the CreatedAfter and CreatedBefore
 * timestamps.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/BackupCreationTimeFilter">AWS
 * API Reference</a></p>
 */
class BackupCreationTimeFilter {
 public:
  AWS_BACKUPSEARCH_API BackupCreationTimeFilter() = default;
  AWS_BACKUPSEARCH_API BackupCreationTimeFilter(Aws::Utils::Json::JsonView jsonValue);
  AWS_BACKUPSEARCH_API BackupCreationTimeFilter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BACKUPSEARCH_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>This timestamp includes recovery points only created after the specified
   * time.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAfter() const { return m_createdAfter; }
  inline bool CreatedAfterHasBeenSet() const { return m_createdAfterHasBeenSet; }
  template <typename CreatedAfterT = Aws::Utils::DateTime>
  void SetCreatedAfter(CreatedAfterT&& value) {
    m_createdAfterHasBeenSet = true;
    m_createdAfter = std::forward<CreatedAfterT>(value);
  }
  template <typename CreatedAfterT = Aws::Utils::DateTime>
  BackupCreationTimeFilter& WithCreatedAfter(CreatedAfterT&& value) {
    SetCreatedAfter(std::forward<CreatedAfterT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>This timestamp includes recovery points only created before the specified
   * time.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedBefore() const { return m_createdBefore; }
  inline bool CreatedBeforeHasBeenSet() const { return m_createdBeforeHasBeenSet; }
  template <typename CreatedBeforeT = Aws::Utils::DateTime>
  void SetCreatedBefore(CreatedBeforeT&& value) {
    m_createdBeforeHasBeenSet = true;
    m_createdBefore = std::forward<CreatedBeforeT>(value);
  }
  template <typename CreatedBeforeT = Aws::Utils::DateTime>
  BackupCreationTimeFilter& WithCreatedBefore(CreatedBeforeT&& value) {
    SetCreatedBefore(std::forward<CreatedBeforeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_createdAfter{};

  Aws::Utils::DateTime m_createdBefore{};
  bool m_createdAfterHasBeenSet = false;
  bool m_createdBeforeHasBeenSet = false;
};

}  // namespace Model
}  // namespace BackupSearch
}  // namespace Aws
