﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ssm/SSM_EXPORTS.h>
#include <aws/ssm/model/OpsItemFilterKey.h>
#include <aws/ssm/model/OpsItemFilterOperator.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SSM {
namespace Model {

/**
 * <p>Describes an OpsItem filter.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/OpsItemFilter">AWS
 * API Reference</a></p>
 */
class OpsItemFilter {
 public:
  AWS_SSM_API OpsItemFilter() = default;
  AWS_SSM_API OpsItemFilter(Aws::Utils::Json::JsonView jsonValue);
  AWS_SSM_API OpsItemFilter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SSM_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the filter.</p>
   */
  inline OpsItemFilterKey GetKey() const { return m_key; }
  inline bool KeyHasBeenSet() const { return m_keyHasBeenSet; }
  inline void SetKey(OpsItemFilterKey value) {
    m_keyHasBeenSet = true;
    m_key = value;
  }
  inline OpsItemFilter& WithKey(OpsItemFilterKey value) {
    SetKey(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The filter value.</p>
   */
  inline const Aws::Vector<Aws::String>& GetValues() const { return m_values; }
  inline bool ValuesHasBeenSet() const { return m_valuesHasBeenSet; }
  template <typename ValuesT = Aws::Vector<Aws::String>>
  void SetValues(ValuesT&& value) {
    m_valuesHasBeenSet = true;
    m_values = std::forward<ValuesT>(value);
  }
  template <typename ValuesT = Aws::Vector<Aws::String>>
  OpsItemFilter& WithValues(ValuesT&& value) {
    SetValues(std::forward<ValuesT>(value));
    return *this;
  }
  template <typename ValuesT = Aws::String>
  OpsItemFilter& AddValues(ValuesT&& value) {
    m_valuesHasBeenSet = true;
    m_values.emplace_back(std::forward<ValuesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The operator used by the filter call.</p>
   */
  inline OpsItemFilterOperator GetOperator() const { return m_operator; }
  inline bool OperatorHasBeenSet() const { return m_operatorHasBeenSet; }
  inline void SetOperator(OpsItemFilterOperator value) {
    m_operatorHasBeenSet = true;
    m_operator = value;
  }
  inline OpsItemFilter& WithOperator(OpsItemFilterOperator value) {
    SetOperator(value);
    return *this;
  }
  ///@}
 private:
  OpsItemFilterKey m_key{OpsItemFilterKey::NOT_SET};

  Aws::Vector<Aws::String> m_values;

  OpsItemFilterOperator m_operator{OpsItemFilterOperator::NOT_SET};
  bool m_keyHasBeenSet = false;
  bool m_valuesHasBeenSet = false;
  bool m_operatorHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSM
}  // namespace Aws
