/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.storage.BytesContentStorage;
import org.jkiss.dbeaver.model.data.storage.TemporaryContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentLOB;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.BeanUtils;

public class OracleContentBFILE
extends JDBCContentLOB {
    private static final Log log = Log.getLog(OracleContentBFILE.class);
    private Object bfile;
    private String name;
    private boolean opened;

    public OracleContentBFILE(DBCExecutionContext executionContext, Object bfile) {
        super(executionContext);
        this.bfile = bfile;
        if (this.bfile != null) {
            try {
                this.name = (String)BeanUtils.invokeObjectMethod((Object)bfile, (String)"getName");
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    public long getLOBLength() throws DBCException {
        if (this.bfile != null) {
            boolean openLocally = !this.opened;
            try {
                Object length;
                if (openLocally) {
                    this.openFile();
                }
                if ((length = BeanUtils.invokeObjectMethod((Object)this.bfile, (String)"length")) instanceof Number) {
                    long l = ((Number)length).longValue();
                    return l;
                }
            }
            catch (Throwable e) {
                throw new DBCException("Error when reading BFILE length", e, this.executionContext);
            }
            finally {
                if (openLocally) {
                    this.closeFile();
                }
            }
        }
        return 0L;
    }

    private void openFile() throws DBCException {
        if (this.opened) {
            return;
        }
        try {
            BeanUtils.invokeObjectMethod((Object)this.bfile, (String)"openFile");
            this.opened = true;
        }
        catch (Throwable e) {
            throw new DBCException(e, this.executionContext);
        }
    }

    private void closeFile() throws DBCException {
        if (!this.opened) {
            return;
        }
        try {
            BeanUtils.invokeObjectMethod((Object)this.bfile, (String)"closeFile");
            this.opened = false;
        }
        catch (Throwable e) {
            throw new DBCException(e, this.executionContext);
        }
    }

    private InputStream getInputStream() throws DBCException {
        try {
            return (InputStream)BeanUtils.invokeObjectMethod((Object)this.bfile, (String)"getBinaryStream");
        }
        catch (Throwable e) {
            throw new DBCException("Error when reading BFILE length", e, this.executionContext);
        }
    }

    @NotNull
    public String getContentType() {
        return "application/octet-stream";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBDContentStorage getContents(@NotNull DBRProgressMonitor monitor) throws DBCException {
        if (this.storage == null && this.bfile != null) {
            try {
                block30: {
                    Path tempFile;
                    this.openFile();
                    long contentLength = this.getContentLength();
                    DBPPlatform platform = DBWorkbench.getPlatform();
                    if (contentLength < (long)platform.getPreferenceStore().getInt("content.memory.maxsize")) {
                        try (InputStream bs = this.getInputStream();){
                            this.storage = BytesContentStorage.createFromStream((InputStream)bs, (long)contentLength, (String)this.getDefaultEncoding());
                            break block30;
                        }
                        catch (IOException e) {
                            throw new DBCException("IO error while reading content", (Throwable)e);
                        }
                    }
                    try {
                        tempFile = ContentUtils.createTempContentFile((DBRProgressMonitor)monitor, (DBPPlatform)platform, (String)("blob" + this.bfile.hashCode()));
                    }
                    catch (IOException e) {
                        throw new DBCException("Can't create temporary file", (Throwable)e);
                    }
                    try (OutputStream os = Files.newOutputStream(tempFile, new OpenOption[0]);
                         InputStream bs = this.getInputStream();){
                        ContentUtils.copyStreams((InputStream)bs, (long)contentLength, (OutputStream)os, (DBRProgressMonitor)monitor);
                    }
                    catch (IOException e) {
                        ContentUtils.deleteTempFile((Path)tempFile);
                        throw new DBCException("IO error while copying stream", (Throwable)e);
                    }
                    catch (Throwable e) {
                        ContentUtils.deleteTempFile((Path)tempFile);
                        throw new DBCException(e, this.executionContext);
                    }
                    this.storage = new TemporaryContentStorage(platform, tempFile, this.getDefaultEncoding(), true);
                }
                this.releaseBlob();
            }
            finally {
                this.closeFile();
            }
        }
        return this.storage;
    }

    public void release() {
        this.releaseBlob();
        super.release();
    }

    private void releaseBlob() {
        if (this.bfile != null) {
            this.bfile = null;
        }
    }

    public void bindParameter(JDBCSession session, JDBCPreparedStatement preparedStatement, DBSTypedObject columnType, int paramIndex) throws DBCException {
        throw new DBCException("BFILE update not supported");
    }

    public Object getRawValue() {
        return this.bfile;
    }

    public boolean isNull() {
        return this.bfile == null && this.storage == null;
    }

    protected JDBCContentLOB createNewContent() {
        return new OracleContentBFILE(this.executionContext, null);
    }

    public String getDisplayString(@NotNull DBDDisplayFormat format) {
        return this.bfile == null && this.storage == null ? null : "[BFILE:" + this.name + "]";
    }
}

