/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.theme.internal.laftheme;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.draggable.DraggableComponentBox;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelContentPanel;
import net.infonode.tabbedpanel.theme.internal.laftheme.ComponentCache;
import net.infonode.tabbedpanel.theme.internal.laftheme.PaneHandler;
import net.infonode.tabbedpanel.theme.internal.laftheme.PaneHandlerListener;
import net.infonode.tabbedpanel.theme.internal.laftheme.PanePainter;
import net.infonode.tabbedpanel.theme.internal.laftheme.PaneUIListener;
import net.infonode.tabbedpanel.theme.internal.laftheme.SizeIcon;
import net.infonode.tabbedpanel.theme.internal.laftheme.TabData;
import net.infonode.util.Direction;

public class PaneUI {
    private static final boolean PAINT_TAB_AREA = true;
    private static final boolean PAINT_CONTENT_AREA = true;
    private static final boolean PAINT_TAB = true;
    private static final boolean TEXT_ICON_GAP_COMPENSATE = true;
    private static final int DEFAULT_SELECTED_INDEX = 3;
    private static final int DEFAULT_TAB_COUNT = 7;
    private static final int EXTRA_SIZE = 2;
    private static final String EMPTY_STRING = "";
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.UP, Direction.LEFT, Direction.DOWN, Direction.RIGHT};
    private final Insets[] areaInsets = new Insets[DIRECTIONS.length];
    private final Insets[] normalInsets = new Insets[DIRECTIONS.length];
    private final Insets[] selectedInsets = new Insets[DIRECTIONS.length];
    private final Insets[] adjustedContentInsets = new Insets[DIRECTIONS.length];
    private final Insets[] adjustedContentInsetsTabAreaHidden = new Insets[DIRECTIONS.length];
    private final Insets[] contentInsets = new Insets[DIRECTIONS.length];
    private final Dimension[] minimumSizes = new Dimension[DIRECTIONS.length];
    private final Dimension[] tabMinimumSizes = new Dimension[DIRECTIONS.length];
    private final int[] spacings = new int[DIRECTIONS.length];
    private final int[] raiseds = new int[DIRECTIONS.length];
    private final Insets[] tabInsets = new Insets[DIRECTIONS.length];
    private final Color[] contentTabAreaBorderColors = new Color[DIRECTIONS.length];
    private final boolean[] swapWidthHeights = new boolean[DIRECTIONS.length];
    private boolean tabAreaNotVisibleFix = false;
    private int scrollOffset = 0;
    private int textIconGap;
    private final PaneUIListener listener;
    private static ComponentCache componentCache = new ComponentCache();
    private final PaneHandler paneHandler = new PaneHandler(new PaneHandlerListener(){

        @Override
        public void updating() {
            PaneUI.this.setEnabled(false);
            PaneUI.this.listener.updating();
        }

        @Override
        public void updated() {
            PaneUI.this.doInit();
            PaneUI.this.setEnabled(true);
            PaneUI.this.listener.updated();
        }
    });
    private Tab hoveredTab;
    private final TabData tabData = new TabData();
    private boolean tabAreaOpaque;
    private boolean contentOpaque;
    private boolean opaque;
    private boolean tabAreaComponentsOpaque;
    private boolean enabled = true;

    public PaneUI(PaneUIListener listener) {
        this.listener = listener;
    }

    public void init() {
        this.paneHandler.update();
    }

    private void doInit() {
        this.initPreCommonValues();
        int i = 0;
        while (i < DIRECTIONS.length) {
            PanePainter pane = this.paneHandler.getPainter(DIRECTIONS[i]);
            this.initValues(pane, i, DIRECTIONS[i]);
            this.reset(pane);
            ++i;
        }
        this.initPostCommonValues();
    }

    public void dispose() {
        this.enabled = false;
        this.paneHandler.dispose();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void initPreCommonValues() {
        this.tabAreaNotVisibleFix = UIManager.getLookAndFeel().getClass().getName().indexOf(".WindowsLookAndFeel") > -1;
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        if (this.textIconGap <= 0) {
            this.textIconGap = 4;
        }
        this.opaque = this.paneHandler.getPainter(Direction.UP).isOpaque();
        Boolean contentOp = (Boolean)UIManager.get("TabbedPane.contentOpaque");
        this.contentOpaque = contentOp == null ? this.opaque : contentOp;
        this.tabAreaOpaque = this.opaque;
        this.tabAreaComponentsOpaque = false;
    }

    private void initPostCommonValues() {
        int i = 0;
        while (i < DIRECTIONS.length) {
            this.scrollOffset = Math.max(this.scrollOffset, Math.max(this.minimumSizes[i].width, this.minimumSizes[i].height));
            ++i;
        }
    }

    private void initValues(PanePainter pane, int index, Direction direction) {
        Insets adjustedInsets;
        this.estimateSwappedTabDirection(pane, index, direction);
        this.reset(pane);
        pane.setSize(1000, 1000);
        boolean upDown = !direction.isHorizontal();
        int i = 0;
        while (i < 7) {
            pane.addTab(EMPTY_STRING, this.getComponent());
            ++i;
        }
        pane.setSelectedIndex(3);
        pane.doValidation();
        Insets insets = UIManager.getInsets("TabbedPane.tabInsets");
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        this.tabInsets[index] = !upDown ? new Insets(0, insets.left, 0, insets.right) : InsetsUtil.EMPTY_INSETS;
        Rectangle bounds = pane.getBoundsAt(0);
        Rectangle bounds2 = pane.getBoundsAt(pane.getSelectedIndex());
        this.raiseds[index] = direction == Direction.UP ? Math.max(0, bounds.y - bounds2.y) : (direction == Direction.LEFT ? Math.max(0, bounds.x - bounds2.x) : (direction == Direction.DOWN ? this.raiseds[this.getDirectionIndex(Direction.UP)] : this.raiseds[this.getDirectionIndex(Direction.LEFT)]));
        Insets normal = this.getCalculatedInsets(pane, 0, false, direction);
        Insets selected = this.getCalculatedInsets(pane, 0, true, direction);
        this.spacings[index] = upDown ? normal.left + normal.right - selected.left - selected.right : normal.top + normal.bottom - selected.top - selected.bottom;
        this.normalInsets[index] = this.getCalculatedInsets(pane, 0, false, direction);
        insets = this.getCalculatedInsets(pane, 0, true, direction);
        int spacing = this.spacings[index];
        int spaceFirst = spacing / 2;
        int spaceAfter = spacing / 2 + spacing % 2;
        if (direction == Direction.UP) {
            insets.bottom = this.normalInsets[index].bottom;
            insets.top = this.normalInsets[index].top;
            insets.left += spaceFirst;
            insets.right += spaceAfter;
        } else if (direction == Direction.LEFT) {
            insets.right = this.normalInsets[index].right;
            insets.left = this.normalInsets[index].left;
            insets.top += spaceFirst;
            insets.bottom += spaceAfter;
        } else if (direction == Direction.RIGHT) {
            insets.right = this.normalInsets[index].right;
            insets.left = this.normalInsets[index].left;
            insets.top += spaceFirst;
            insets.bottom += spaceAfter;
        } else {
            insets.bottom = this.normalInsets[index].bottom;
            insets.top = this.normalInsets[index].top;
            insets.left += spaceFirst;
            insets.right += spaceAfter;
        }
        this.selectedInsets[index] = insets;
        JPanel c = new JPanel();
        pane.addTab(EMPTY_STRING, c);
        pane.setSelectedIndex(pane.getTabCount() - 1);
        pane.doValidation();
        Point l = SwingUtilities.convertPoint(c.getParent(), c.getLocation(), pane);
        Rectangle bounds3 = pane.getBoundsAt(0);
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        if (direction == Direction.UP) {
            top = l.y - bounds3.height - bounds3.y;
            left = l.x;
            bottom = pane.getHeight() - l.y - c.getHeight();
            right = pane.getWidth() - l.x - c.getWidth();
        } else if (direction == Direction.DOWN) {
            top = l.y;
            left = l.x;
            bottom = pane.getHeight() - c.getHeight() - l.y - (pane.getHeight() - bounds3.y);
            right = pane.getWidth() - l.x - c.getWidth();
        } else if (direction == Direction.LEFT) {
            top = l.y;
            left = l.x - bounds3.width - bounds3.x;
            bottom = pane.getHeight() - l.y - c.getHeight();
            right = pane.getWidth() - l.x - c.getWidth();
        } else {
            top = l.y;
            left = l.x;
            bottom = pane.getHeight() - l.y - c.getHeight();
            right = pane.getWidth() - c.getWidth() - l.x - (pane.getWidth() - bounds3.x);
        }
        this.contentInsets[index] = new Insets(top, left, bottom, right);
        Insets i2 = this.contentInsets[0];
        Insets i22 = InsetsUtil.rotate(direction.getNextCW(), i2);
        this.adjustedContentInsets[index] = adjustedInsets = InsetsUtil.max(i2, i22);
        this.adjustedContentInsetsTabAreaHidden[index] = new Insets(direction == Direction.UP ? adjustedInsets.left : adjustedInsets.top, direction == Direction.LEFT ? adjustedInsets.top : adjustedInsets.left, direction == Direction.DOWN ? adjustedInsets.right : adjustedInsets.bottom, direction == Direction.RIGHT ? adjustedInsets.bottom : adjustedInsets.right);
        pane.removeTabAt(pane.getTabCount() - 1);
        pane.setSelectedIndex(3);
        pane.doValidation();
        bounds = pane.getBoundsAt(3);
        this.tabMinimumSizes[index] = new Dimension(bounds.width, bounds.height);
        this.minimumSizes[index] = new Dimension(bounds.width - this.tabInsets[index].left - this.tabInsets[index].right, bounds.height - this.tabInsets[index].top - this.tabInsets[index].bottom);
        this.calculateAreaInsets(pane, index, direction);
        this.estimateContentTabAreaBorderColor(pane, index, direction);
    }

    private void calculateAreaInsets(PanePainter pane, int index, Direction direction) {
        pane.setSelectedIndex(0);
        Rectangle selectedBounds = pane.getBoundsAt(0);
        pane.setSelectedIndex(3);
        Rectangle normalBounds = pane.getBoundsAt(0);
        int left = 0;
        int top = 0;
        int bottom = 0;
        int right = 0;
        if (direction == Direction.UP) {
            left = Math.min(selectedBounds.x, normalBounds.x);
            top = Math.min(selectedBounds.y, normalBounds.y);
            bottom = 0;
        } else if (direction == Direction.DOWN) {
            left = Math.min(selectedBounds.x, normalBounds.x);
            top = 0;
            bottom = pane.getHeight() - Math.max(selectedBounds.y + selectedBounds.height, normalBounds.y + normalBounds.height);
        } else if (direction == Direction.LEFT) {
            top = Math.min(selectedBounds.y, normalBounds.y);
            left = Math.min(selectedBounds.x, normalBounds.x);
            right = 0;
        } else {
            top = Math.min(selectedBounds.y, normalBounds.y);
            left = 0;
            right = pane.getWidth() - Math.max(selectedBounds.x + selectedBounds.width, normalBounds.x + normalBounds.width);
        }
        Dimension size = pane.getSize();
        this.reset(pane);
        int i = 0;
        while (i < 4) {
            pane.addTab(EMPTY_STRING, SizeIcon.EMPTY, this.getComponent());
            ++i;
        }
        pane.setSelectedIndex(-1);
        pane.setSize(pane.getMinimumSize());
        pane.doValidation();
        if (!direction.isHorizontal()) {
            int width = pane.getWidth() - 1;
            boolean found = false;
            while (!found) {
                pane.setSize(++width, pane.getHeight());
                pane.doValidation();
                boolean bl = found = pane.getBoundsAt((int)0).y == pane.getBoundsAt((int)3).y;
            }
            Rectangle endBounds = pane.getBoundsAt(3);
            right = pane.getWidth() - endBounds.x - endBounds.width - this.spacings[index];
        } else {
            int height = pane.getHeight() - 1;
            boolean found = false;
            while (!found) {
                pane.setSize(pane.getWidth(), ++height);
                pane.doValidation();
                boolean bl = found = pane.getBoundsAt((int)0).x == pane.getBoundsAt((int)3).x;
            }
            Rectangle endBounds = pane.getBoundsAt(3);
            bottom = pane.getHeight() - endBounds.y - endBounds.height - this.spacings[index];
        }
        this.areaInsets[index] = new Insets(top, left, bottom, right);
        pane.setSize(size);
        pane.doValidation();
    }

    private void estimateContentTabAreaBorderColor(PanePainter pane, int index, final Direction direction) {
        Dimension preSize = pane.getSize();
        this.reset(pane);
        pane.addTab(EMPTY_STRING, SizeIcon.EMPTY, this.getComponent());
        pane.setSelectedIndex(-1);
        Dimension size = pane.getMinimumSize();
        if (direction.isHorizontal()) {
            pane.setSize(size.width, size.height * 2);
        } else {
            pane.setSize(size.width * 2, size.height);
        }
        pane.doValidation();
        Rectangle tabBounds = pane.getBoundsAt(0);
        BufferedImage img = new BufferedImage(pane.getWidth(), pane.getHeight(), 2);
        int x = 0;
        int y = 0;
        if (direction == Direction.UP) {
            x = tabBounds.x + tabBounds.width / 2;
            y = pane.getHeight() - this.contentInsets[index].top - this.contentInsets[index].bottom - 1;
        } else if (direction == Direction.DOWN) {
            x = tabBounds.x + tabBounds.width / 2;
            y = this.contentInsets[index].top + this.contentInsets[index].bottom;
        } else if (direction == Direction.LEFT) {
            x = pane.getWidth() - this.contentInsets[index].left - this.contentInsets[index].right - 1;
            y = tabBounds.y + tabBounds.height / 2;
        } else {
            x += this.contentInsets[index].left + this.contentInsets[index].right;
            y = tabBounds.y + tabBounds.height / 2;
        }
        final int px = x;
        final int py = y;
        RGBImageFilter colorFilter = new RGBImageFilter(){

            @Override
            public int filterRGB(int x, int y, int rgb) {
                if (px == x && py == y) {
                    int r = rgb >> 16 & 0xFF;
                    int g = rgb >> 8 & 0xFF;
                    int b = rgb & 0xFF;
                    int a = rgb >> 24 & 0xFF;
                    ((PaneUI)PaneUI.this).contentTabAreaBorderColors[((PaneUI)PaneUI.this).getDirectionIndex((Direction)direction.getOpposite())] = new Color(r, g, b, a);
                }
                return rgb;
            }
        };
        FilteredImageSource source = new FilteredImageSource(img.getSource(), colorFilter);
        pane.paint(img.getGraphics());
        BufferedImage img2 = new BufferedImage(pane.getWidth(), pane.getHeight(), 2);
        img2.getGraphics().drawImage(Toolkit.getDefaultToolkit().createImage(source), 0, 0, null);
        pane.setSize(preSize);
        pane.doValidation();
    }

    private void estimateSwappedTabDirection(PanePainter pane, int index, Direction direction) {
        this.reset(pane);
        SizeIcon icon = new SizeIcon(80, 80);
        SizeIcon icon2 = new SizeIcon(160, 80);
        pane.addTab(EMPTY_STRING, icon, this.getComponent());
        pane.doValidation();
        Rectangle bounds = pane.getBoundsAt(0);
        pane.setIconAt(0, icon2);
        pane.doValidation();
        Rectangle bounds2 = pane.getBoundsAt(0);
        this.swapWidthHeights[index] = (double)bounds2.height > 1.5 * (double)bounds.height;
    }

    public boolean isContentOpaque() {
        return this.contentOpaque;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public boolean isTabAreaComponentsOpaque() {
        return this.tabAreaComponentsOpaque;
    }

    public boolean isTabAreaOpaque() {
        return this.tabAreaOpaque;
    }

    public Font getFont() {
        return this.paneHandler.getPainter(Direction.UP).getFont();
    }

    public boolean isSwapWidthHeight(Direction d) {
        return this.swapWidthHeights[this.getDirectionIndex(d)];
    }

    public Insets getNormalInsets(Direction d) {
        return this.normalInsets[this.getDirectionIndex(d)];
    }

    public Insets getSelectedInsets(Direction d) {
        return this.selectedInsets[this.getDirectionIndex(d)];
    }

    public Insets getNormalTabInsets(Direction areaOrientation, Direction tabDirection) {
        return this.getRealTabInsets(areaOrientation, tabDirection, this.getNormalInsets(areaOrientation));
    }

    public Insets getSelectedTabInsets(Direction areaOrientation, Direction tabDirection) {
        return this.getRealTabInsets(areaOrientation, tabDirection, this.getSelectedInsets(areaOrientation));
    }

    private Insets getRealTabInsets(Direction areaOrientation, Direction tabDirection, Insets insets) {
        insets = InsetsUtil.rotate(tabDirection, insets);
        if (this.swapWidthHeights[this.getDirectionIndex(areaOrientation)]) {
            insets = InsetsUtil.rotate(areaOrientation.getNextCCW(), insets);
        }
        return insets;
    }

    public Insets getContentInsets(Direction d, boolean tabAreaVisible) {
        return tabAreaVisible ? this.adjustedContentInsets[this.getDirectionIndex(d)] : this.adjustedContentInsetsTabAreaHidden[this.getDirectionIndex(d)];
    }

    public Insets getTabAreaInsets(Direction d) {
        return this.areaInsets[this.getDirectionIndex(d)];
    }

    public Dimension getTabExternalMinSize(Direction d) {
        return this.minimumSizes[this.getDirectionIndex(d)];
    }

    public Insets getTabInsets(Direction d) {
        return this.tabInsets[this.getDirectionIndex(d)];
    }

    public int getTabSpacing(Direction d) {
        return this.spacings[this.getDirectionIndex(d)];
    }

    public int getSelectedRaised(Direction d) {
        return this.raiseds[this.getDirectionIndex(d)];
    }

    public Color getContentTabAreaBorderColor(Direction d) {
        return this.contentTabAreaBorderColors[this.getDirectionIndex(d)];
    }

    public int getTabSpacing() {
        return 0;
    }

    public int getTextIconGap() {
        return this.textIconGap;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    private int getWidthCompensate(Direction d) {
        if (this.swapWidthHeights[this.getDirectionIndex(d)]) {
            return 0;
        }
        return this.getTextIconGap();
    }

    private int getHeightCompensate(Direction d) {
        if (!this.swapWidthHeights[this.getDirectionIndex(d)]) {
            return 0;
        }
        return this.getTextIconGap();
    }

    private int getDirectionIndex(Direction d) {
        int i = 0;
        while (i < DIRECTIONS.length) {
            if (DIRECTIONS[i] == d) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private Insets getCalculatedInsets(PanePainter pane, int index, boolean selected, Direction direction) {
        Rectangle b = pane.getBoundsAt(index);
        int sizer = b.height + b.width;
        Icon icon = pane.getIconAt(index);
        pane.setIconAt(index, new SizeIcon(sizer, sizer));
        if (selected) {
            pane.setSelectedIndex(index);
        }
        Rectangle bounds = pane.getBoundsAt(index);
        pane.setIconAt(index, icon);
        pane.setSelectedIndex(3);
        int height = bounds.height - sizer - this.getHeightCompensate(direction);
        int width = bounds.width - sizer - this.getWidthCompensate(direction);
        int top = height / 2;
        int left = width / 2 + width % 2;
        int bottom = height / 2 + height % 2;
        int right = width / 2;
        return new Insets(top, left, bottom, right);
    }

    public void setHoveredTab(Tab tab) {
        if (this.enabled && tab != this.hoveredTab) {
            if (this.hoveredTab != null && this.hoveredTab.getTabbedPanel() != null) {
                this.findDraggableComponentBox(this.hoveredTab).getParent().repaint();
            }
            this.hoveredTab = tab;
            if (this.hoveredTab != null && this.hoveredTab.getTabbedPanel() != null) {
                this.findDraggableComponentBox(this.hoveredTab).getParent().repaint();
            }
        }
    }

    public void paintTabArea(TabbedPanel tp, Graphics g, int x, int y, int width, int height) {
        if (this.enabled && tp.isTabAreaVisible()) {
            this.tabData.initialize(tp);
            PanePainter pane = this.paneHandler.getPainter(this.tabData.getAreaOrientation());
            this.initTabLocations(pane);
            Insets aInsets = this.getTabAreaInsets(this.tabData.getAreaOrientation());
            if (tp.getTabCount() > 0) {
                if (this.tabData.getAreaOrientation() == Direction.DOWN) {
                    y += this.tabData.getTabbedPanelHeight() - height;
                } else if (this.tabData.getAreaOrientation() == Direction.RIGHT) {
                    x += this.tabData.getTabbedPanelWidth() - width;
                }
                width = x < 0 ? width + x : width;
                height = y < 0 ? height + y : height;
                x = Math.max(0, x);
                y = Math.max(0, y);
                if (this.tabData.isHorizontalLayout()) {
                    pane.setSize(this.tabData.getTabbedPanelSize().width, this.getTabbedPanelExtraSize());
                } else {
                    pane.setSize(this.getTabbedPanelExtraSize(), this.tabData.getTabbedPanelHeight());
                }
                if (pane.getTabCount() != 0 || this.tabData.getTabCount() <= 0) {
                    Shape originalClip = g.getClip();
                    int tx = -x - (this.tabData.getAreaOrientation() == Direction.RIGHT ? -this.tabData.getTabbedPanelWidth() + this.getTabbedPanelExtraSize() : 0);
                    int ty = -y - (this.tabData.getAreaOrientation() == Direction.DOWN ? -this.tabData.getTabbedPanelHeight() + this.getTabbedPanelExtraSize() : 0);
                    Rectangle firstVisibleRect = (Rectangle)this.tabData.getVisibleTabRects().get(0);
                    Rectangle lastVisibleRect = (Rectangle)this.tabData.getVisibleTabRects().get(this.tabData.getTabCount() - 1);
                    Tab lastTab = (Tab)this.tabData.getTabList().get(this.tabData.getTabCount() - 1);
                    if (this.tabData.isHorizontalLayout()) {
                        int extraWidth = lastTab.getWidth() == lastVisibleRect.width ? 0 : 2 * this.tabData.getTabbedPanelSize().width - this.tabData.getTabAreaWidth();
                        pane.setSize(pane.getWidth() + extraWidth, pane.getHeight());
                        pane.doValidation();
                        g.clipRect(0, 0, aInsets.left + (firstVisibleRect.width > 0 && firstVisibleRect.x == 0 ? 1 : 0), height);
                        pane.paint(g, tx, ty);
                        g.setClip(originalClip);
                        int clipExtraWidth = extraWidth == 0 ? 1 : 0;
                        g.clipRect(aInsets.left + this.tabData.getTabAreaWidth() - clipExtraWidth, 0, width - aInsets.left - this.tabData.getTabAreaWidth() + clipExtraWidth, height);
                        pane.paint(g, tx -= extraWidth, ty);
                        g.setClip(originalClip);
                    } else {
                        int extraHeight = lastTab.getHeight() == lastVisibleRect.height ? 0 : 2 * this.tabData.getTabbedPanelSize().height - this.tabData.getTabAreaHeight();
                        pane.setSize(pane.getWidth(), pane.getHeight() + extraHeight);
                        pane.doValidation();
                        g.clipRect(0, 0, width, aInsets.top + (firstVisibleRect.height > 0 && firstVisibleRect.y == 0 ? 1 : 0));
                        pane.paint(g, tx, ty);
                        g.setClip(originalClip);
                        int clipExtraHeight = extraHeight == 0 ? 1 : 0;
                        g.clipRect(0, aInsets.top + this.tabData.getTabAreaHeight() - clipExtraHeight, width, height - aInsets.top - this.tabData.getTabAreaHeight() + clipExtraHeight);
                        pane.paint(g, tx, ty -= extraHeight);
                        g.setClip(originalClip);
                    }
                }
                this.paintTabs(pane, this.tabData, g, x, y, width, height, true);
                this.tabData.reset();
                this.reset(pane);
            }
        }
    }

    private void paintTabs(PanePainter pane, TabData tabData, Graphics g, int x, int y, int width, int height, boolean first) {
        if (this.enabled) {
            int i;
            Tab lastTab = (Tab)tabData.getTabList().get(tabData.getTabList().size() - 1);
            Rectangle lastVisibleRect = (Rectangle)tabData.getVisibleTabRects().get(tabData.getTabCount() - 1);
            this.initPaintableTabLocations(pane);
            Insets aInsets = this.getTabAreaInsets(tabData.getAreaOrientation());
            Point l = this.getLocationInTabbedPanel(lastTab, tabData.getTabbedPanel());
            if (tabData.isHorizontalLayout()) {
                int w = aInsets.left + aInsets.right + Math.max(0, tabData.getTabAreaWidth() - l.x - lastVisibleRect.width) + 2;
                i = 0;
                while (i < tabData.getTabList().size()) {
                    w += ((Tab)tabData.getTabList().get(i)).getWidth();
                    ++i;
                }
                pane.setSize(w, this.getTabbedPanelExtraSize());
            } else {
                int h = aInsets.top + aInsets.bottom + Math.max(0, tabData.getTabAreaHeight() - l.y - lastVisibleRect.height) + 2;
                i = 0;
                while (i < tabData.getTabList().size()) {
                    h += ((Tab)tabData.getTabList().get(i)).getHeight();
                    ++i;
                }
                pane.setSize(this.getTabbedPanelExtraSize(), h);
            }
            pane.doValidation();
            int index = tabData.getPreTab() == null ? 0 : (tabData.getTabCount() > 1 ? 1 : 0);
            Shape originalClip = g.getClip();
            int tx = -x - (tabData.getAreaOrientation() == Direction.RIGHT ? -tabData.getTabbedPanelWidth() + this.getTabbedPanelExtraSize() : 0);
            int ty = -y - (tabData.getAreaOrientation() == Direction.DOWN ? -tabData.getTabbedPanelHeight() + this.getTabbedPanelExtraSize() : 0);
            Rectangle visibleRect = (Rectangle)tabData.getVisibleTabRects().get(index);
            Tab tab = (Tab)tabData.getTabList().get(index);
            if (tabData.isHorizontalLayout()) {
                tx -= tabData.getPreTab() != null ? tab.getX() - tabData.getPreTab().getX() + visibleRect.x : visibleRect.x;
                g.clipRect(aInsets.left, 0, tabData.getTabAreaWidth(), height);
            } else {
                ty -= tabData.getPreTab() != null ? tab.getY() - tabData.getPreTab().getY() + visibleRect.y : visibleRect.y;
                g.clipRect(0, aInsets.top, width, tabData.getTabAreaHeight());
            }
            this.applyFocusAndHover(pane, true);
            pane.paint(g, tx, ty);
            this.applyFocusAndHover(pane, false);
            g.setClip(originalClip);
        }
    }

    private int getTabbedPanelExtraSize() {
        Insets insets = this.getContentInsets(this.tabData.getAreaOrientation(), this.tabData.getTabbedPanel().isTabAreaVisible());
        if (this.tabData.isHorizontalLayout()) {
            return this.tabData.getTabAreaHeight() + insets.top + insets.bottom + 2;
        }
        return this.tabData.getTabAreaWidth() + insets.left + insets.right + 2;
    }

    public void paintContentArea(TabbedPanelContentPanel p, Graphics g, int x, int y, int width, int height) {
        if (this.enabled) {
            this.tabData.initialize(p.getTabbedPanel());
            PanePainter pane = this.paneHandler.getPainter(this.tabData.getAreaOrientation());
            this.initTabLocations(pane);
            int tx = 0;
            int ty = 0;
            if (this.tabData.getTabbedPanel().hasContentArea()) {
                Point l = this.getLocationInTabbedPanel(p, this.tabData.getTabbedPanel());
                int yComp = 0;
                int xComp = 0;
                if (pane.getTabCount() == 0 && this.tabData.getTabCount() > 0) {
                    if (this.tabData.getAreaOrientation() == Direction.UP) {
                        yComp = this.tabData.getTabAreaHeight();
                    } else if (this.tabData.getAreaOrientation() == Direction.DOWN) {
                        yComp = -this.tabData.getTabAreaHeight();
                    } else {
                        xComp = this.tabData.getAreaOrientation() == Direction.LEFT ? this.tabData.getTabAreaWidth() : -this.tabData.getTabAreaWidth();
                    }
                }
                tx = -l.x + (xComp > 0 ? xComp : 0);
                ty = -l.y + (yComp > 0 ? yComp : 0);
                int extraWidth = 0;
                int extraHeight = 0;
                if (this.tabAreaNotVisibleFix && !this.tabData.getTabbedPanel().isTabAreaVisible()) {
                    int n = !this.tabData.isHorizontalLayout() ? this.tabMinimumSizes[this.getDirectionIndex((Direction)this.tabData.getAreaOrientation())].width - this.raiseds[this.getDirectionIndex(this.tabData.getAreaOrientation())] + (this.tabData.getAreaOrientation() == Direction.LEFT ? this.areaInsets[this.getDirectionIndex((Direction)Direction.LEFT)].left : this.areaInsets[this.getDirectionIndex((Direction)Direction.RIGHT)].right) : (extraWidth = 0);
                    extraHeight = this.tabData.isHorizontalLayout() ? this.tabMinimumSizes[this.getDirectionIndex((Direction)this.tabData.getAreaOrientation())].height - this.raiseds[this.getDirectionIndex(this.tabData.getAreaOrientation())] + (this.tabData.getAreaOrientation() == Direction.UP ? this.areaInsets[this.getDirectionIndex((Direction)Direction.UP)].top : this.areaInsets[this.getDirectionIndex((Direction)Direction.DOWN)].bottom) : 0;
                }
                tx -= this.tabData.getAreaOrientation() == Direction.LEFT ? extraWidth : 0;
                ty -= this.tabData.getAreaOrientation() == Direction.UP ? extraHeight : 0;
                pane.setSize(this.tabData.getTabbedPanelSize().width - Math.abs(xComp) + extraWidth, this.tabData.getTabbedPanelSize().height - Math.abs(yComp) + extraHeight);
                pane.doValidation();
            } else {
                if (this.tabData.isHorizontalLayout()) {
                    pane.setSize(p.getWidth(), p.getHeight() + this.tabData.getTabAreaHeight());
                } else {
                    pane.setSize(p.getWidth() + this.tabData.getTabAreaWidth(), p.getHeight());
                }
                pane.doValidation();
                if (this.tabData.getAreaOrientation() == Direction.UP) {
                    ty -= this.tabData.getTabAreaHeight();
                } else if (this.tabData.getAreaOrientation() == Direction.LEFT) {
                    tx -= this.tabData.getTabAreaWidth();
                }
            }
            pane.paint(g, tx, ty);
            this.tabData.reset();
            this.reset(pane);
        }
    }

    private Component getComponent() {
        return componentCache.getComponent();
    }

    private void reset(PanePainter pane) {
        pane.removeAllTabs();
        componentCache.reset();
    }

    private Point getLocationInTabbedPanel(Component c, TabbedPanel tp) {
        Point l = SwingUtilities.convertPoint(c.getParent(), c.getLocation(), tp);
        Insets tpInsets = tp.getInsets();
        l.x -= tpInsets.left;
        l.y -= tpInsets.top;
        return l;
    }

    private void initPaintableTabLocations(PanePainter pane) {
        this.reset(pane);
        if (this.tabData.getPreTab() != null) {
            this.tabData.getTabList().add(0, this.tabData.getPreTab());
            this.tabData.getVisibleTabRects().add(0, new Rectangle(0, 0, 0, 0));
        }
        if (this.tabData.getPostTab() != null) {
            this.tabData.getTabList().add(this.tabData.getPostTab());
            this.tabData.getVisibleTabRects().add(new Rectangle(0, 0, 0, 0));
        }
        int size = 0;
        int selectedIndex = -1;
        int i = 0;
        while (i < this.tabData.getTabCount()) {
            Tab tab = (Tab)this.tabData.getTabList().get(i);
            SizeIcon icon = new SizeIcon(this.getInternalTabWidth(tab) - this.getWidthCompensate(this.tabData.getAreaOrientation()), this.getInternalTabHeight(tab) - this.getHeightCompensate(this.tabData.getAreaOrientation()), this.isSwapWidthHeight(this.tabData.getAreaOrientation()));
            pane.addTab(EMPTY_STRING, icon, this.getComponent());
            if (tab.isHighlighted()) {
                selectedIndex = pane.getTabCount() - 1;
            }
            if (!tab.isEnabled()) {
                pane.setEnabledAt(i, false);
                pane.setDisabledIconAt(i, icon);
            }
            size += this.tabData.isHorizontalLayout() ? tab.getWidth() : tab.getHeight();
            ++i;
        }
        pane.setSelectedIndex(selectedIndex);
        pane.doValidation();
    }

    private void applyFocusAndHover(PanePainter pane, boolean active) {
        if (active) {
            Tab tab;
            int i = 0;
            while (i < this.tabData.getTabCount()) {
                tab = (Tab)this.tabData.getTabList().get(i);
                if (tab.getFocusableComponent() != null && tab.getFocusableComponent().hasFocus()) {
                    pane.setMouseEntered(true);
                    pane.setFocusActive(true);
                    break;
                }
                ++i;
            }
            if (this.hoveredTab != null) {
                i = 0;
                while (i < this.tabData.getTabCount()) {
                    tab = (Tab)this.tabData.getTabList().get(i);
                    if (tab == this.hoveredTab) {
                        pane.setMouseEntered(true);
                        pane.setHoveredTab(i);
                        break;
                    }
                    ++i;
                }
            }
        } else {
            pane.setFocusActive(false);
            pane.setMouseEntered(false);
        }
    }

    private int getInternalTabWidth(Tab tab) {
        Direction areaOrientation = tab.getTabbedPanel().getProperties().getTabAreaOrientation();
        Insets insets = tab.isHighlighted() ? this.getSelectedInsets(areaOrientation) : this.getNormalInsets(areaOrientation);
        int width = tab.getWidth();
        width -= insets.left + insets.right;
        if (areaOrientation == Direction.LEFT || areaOrientation == Direction.RIGHT) {
            width -= this.getSelectedRaised(areaOrientation);
        }
        return width;
    }

    private int getInternalTabHeight(Tab tab) {
        Direction areaOrientation = tab.getTabbedPanel().getProperties().getTabAreaOrientation();
        Insets insets = tab.isHighlighted() ? this.getSelectedInsets(areaOrientation) : this.getNormalInsets(areaOrientation);
        int height = tab.getHeight();
        height -= insets.top + insets.bottom;
        if (areaOrientation == Direction.UP || areaOrientation == Direction.DOWN) {
            height -= this.getSelectedRaised(areaOrientation);
        }
        return height;
    }

    private void initTabLocations(PanePainter pane) {
        this.findPaintableTabs();
        Dimension minSize = this.getTabExternalMinSize(this.tabData.getAreaOrientation());
        Insets aInsets = this.getTabAreaInsets(this.tabData.getAreaOrientation());
        int selectedIndex = -1;
        if (this.tabData.getTabbedPanel().isTabAreaVisible()) {
            int i = 0;
            while (i < this.tabData.getTabCount()) {
                Tab tab = (Tab)this.tabData.getTabList().get(i);
                Rectangle visibleRect = (Rectangle)this.tabData.getVisibleTabRects().get(i);
                Insets insets = this.getTabInsets(this.tabData.getAreaOrientation());
                int iconWidth = Math.max(-insets.left - insets.right, this.getInternalTabWidth(tab) - (tab.getWidth() - visibleRect.width));
                int iconHeight = Math.max(-insets.top - insets.bottom, this.getInternalTabHeight(tab) - (tab.getHeight() - visibleRect.height));
                Point l = this.getLocationInTabbedPanel(tab, this.tabData.getTabbedPanel());
                if (this.tabData.isHorizontalLayout() && (visibleRect.width >= minSize.width || minSize.width < this.tabData.getTabbedPanelWidth() - l.x - aInsets.right) || !this.tabData.isHorizontalLayout() && (visibleRect.height >= minSize.height || minSize.height < this.tabData.getTabbedPanelHeight() - l.y - aInsets.bottom)) {
                    int iWidth = iconWidth;
                    int iHeight = iconHeight;
                    SizeIcon icon = new SizeIcon(iWidth - this.getWidthCompensate(this.tabData.getAreaOrientation()), iHeight - this.getHeightCompensate(this.tabData.getAreaOrientation()), this.isSwapWidthHeight(this.tabData.getAreaOrientation()));
                    int j = pane.getTabCount();
                    pane.addTab(EMPTY_STRING, icon, this.getComponent());
                    if (i == this.tabData.getSelectedTabPainterIndex()) {
                        selectedIndex = j;
                    }
                    if (!tab.isEnabled()) {
                        pane.setEnabledAt(j, false);
                        pane.setDisabledIconAt(j, icon);
                    }
                }
                ++i;
            }
        } else if (this.tabAreaNotVisibleFix) {
            pane.addTab(EMPTY_STRING, componentCache.getComponent());
        }
        if (pane.getTabCount() > 0) {
            pane.setSelectedIndex(selectedIndex);
        }
        pane.doValidation();
    }

    private void findPaintableTabs() {
        Tab firstTab = null;
        Rectangle firstVisibleRect = null;
        Tab previousTab = null;
        int i = 0;
        boolean tabsFound = false;
        if (this.tabData.getTabbedPanel().isTabAreaVisible()) {
            while (i < this.tabData.getTabbedPanel().getTabCount()) {
                Tab tab = this.tabData.getTabbedPanel().getTabAt(i);
                Rectangle r = tab.getVisibleRect();
                if (i == 0) {
                    firstTab = tab;
                    firstVisibleRect = r;
                }
                ++i;
                if (r.width > 0 && r.height > 0) {
                    tabsFound = true;
                    this.tabData.getTabList().add(tab);
                    this.tabData.getVisibleTabRects().add(r);
                    if (this.tabData.getTabCount() == 1) {
                        this.tabData.setPreTab(previousTab);
                    }
                    if (tab.isHighlighted()) {
                        this.tabData.setSelectedTabPainterIndex(this.tabData.getTabCount() - 1);
                    }
                } else if (this.tabData.getTabList().size() > 0 && (r.width == 0 || r.height == 0)) {
                    this.tabData.setPostTab(tab);
                }
                if (tabsFound && r.x == 0 && r.y == 0 && (this.tabData.isHorizontalLayout() && r.width < tab.getWidth() || !this.tabData.isHorizontalLayout() && r.height < tab.getHeight())) break;
                previousTab = tab;
            }
            if (firstTab != null) {
                Component box = this.findDraggableComponentBox(firstTab);
                if (box != null) {
                    if (this.tabData.isHorizontalLayout()) {
                        this.tabData.setTabAreaWidth(box.getWidth());
                        this.tabData.setTabAreaHeight(box.getParent().getHeight());
                    } else {
                        this.tabData.setTabAreaWidth(box.getParent().getWidth());
                        this.tabData.setTabAreaHeight(box.getHeight());
                    }
                }
                if (this.tabData.getTabCount() == 0) {
                    this.tabData.getTabList().add(firstTab);
                    this.tabData.getVisibleTabRects().add(firstVisibleRect);
                }
            }
        }
    }

    private Component findDraggableComponentBox(Component c) {
        if (c == null || c instanceof DraggableComponentBox) {
            return c;
        }
        return this.findDraggableComponentBox(c.getParent());
    }
}

