/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.configurator;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.freeplane.extension.ArchitectureViolations;
import com.tngtech.archunit.freeplane.extension.ViolationDescription;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.AutoResizedTable;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.TextUtils;
import org.freeplane.plugin.codeexplorer.archunit.ArchUnitServer;
import org.freeplane.plugin.codeexplorer.archunit.ArchitectureViolationsConfiguration;
import org.freeplane.plugin.codeexplorer.configurator.CodeProjectController;
import org.freeplane.plugin.codeexplorer.configurator.WrappingTableCellRenderer;

class ArchitectureViolationsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DefaultTableModel ruleTableModel;
    private DefaultTableModel violationTableModel;
    private JTable ruleTable;
    private JTable violationTable;
    private final CodeProjectController codeProjectController;
    private final ArchUnitServer archUnitServer;
    private Map<String, Dependency> violatingDependencies;
    private ArchitectureViolations selectedViolations;
    private JavaClasses classes;
    private int selectedTestResultIndex;
    private int exploredTestResultIndex;
    private static final Icon EXPLORE_ICON = ResourceController.getResourceController().getImageIcon("code.explore.icon");

    ArchitectureViolationsPanel(CodeProjectController codeProjectController, ArchUnitServer archUnitServer, AFreeplaneAction enableServerAction) {
        this.codeProjectController = codeProjectController;
        this.archUnitServer = archUnitServer;
        this.violatingDependencies = Collections.emptyMap();
        this.exploredTestResultIndex = -1;
        this.selectedTestResultIndex = -1;
        archUnitServer.setCallback(this::testResultAdded);
        this.createPanels(enableServerAction);
        this.updateRuleTable();
    }

    private void testResultAdded(ArchitectureViolations result) {
        this.addNewTestResult(result.getViolatedRuleDescription());
    }

    private void updateRuleTable() {
        this.ruleTableModel.setRowCount(0);
        for (ArchitectureViolations rule : this.submittedTestResults()) {
            this.ruleTableModel.addRow(new Object[]{rule.getViolatedRuleDescription()});
        }
    }

    private JComponent createRulePanel() {
        this.ruleTableModel = this.createEmptyTableModel();
        this.ruleTable = new JTable(this.ruleTableModel);
        WrappingTableCellRenderer renderer = new WrappingTableCellRenderer(){

            @Override
            public WrappingTableCellRenderer getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                WrappingTableCellRenderer component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (row == ArchitectureViolationsPanel.this.exploredTestResultIndex) {
                    component.setIcon(EXPLORE_ICON);
                } else {
                    component.setIcon(null);
                }
                return component;
            }
        };
        this.ruleTable.setDefaultRenderer(Object.class, renderer);
        this.ruleTable.setSelectionMode(1);
        JScrollPane ruleTableScrollPane = new JScrollPane(this.ruleTable);
        this.ruleTable.getSelectionModel().addListSelectionListener(e -> this.updateViolations());
        return ruleTableScrollPane;
    }

    private JComponent createViolationsPane() {
        this.violationTableModel = this.createEmptyTableModel();
        this.violationTable = new AutoResizedTable((TableModel)this.violationTableModel);
        this.violationTable.getTableHeader().setVisible(false);
        this.violationTable.getSelectionModel().setSelectionMode(2);
        this.violationTable.getColumnModel().getSelectionModel().setSelectionMode(0);
        WrappingTableCellRenderer renderer = new WrappingTableCellRenderer();
        TableColumn violationsColumn = this.violationTable.getColumnModel().getColumn(0);
        violationsColumn.setCellRenderer(renderer);
        JScrollPane violationsTableScrollPane = new JScrollPane(this.violationTable);
        violationsTableScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ArchitectureViolationsPanel.this.violationTable.revalidate();
                ArchitectureViolationsPanel.this.violationTable.repaint();
            }
        });
        return violationsTableScrollPane;
    }

    private DefaultTableModel createEmptyTableModel() {
        return new DefaultTableModel(new Object[]{""}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
    }

    private void updateViolations() {
        this.violationTableModel.setRowCount(0);
        if (this.ruleTable.getSelectedRowCount() != 1) {
            this.selectedTestResultIndex = -1;
        } else {
            this.selectedTestResultIndex = this.ruleTable.getSelectedRow();
            this.selectedViolations = this.getSelectedViolations();
            for (ViolationDescription description : this.selectedViolations.getViolationDescriptions()) {
                this.violationTableModel.addRow(new Object[]{description.getFullDescription()});
            }
        }
    }

    private void exploreSelectedTestResult() {
        if (this.selectedTestResultIndex == -1) {
            return;
        }
        this.exploredTestResultIndex = this.selectedTestResultIndex;
        ArchitectureViolations selectedTestResult = this.getSelectedViolations();
        ArchitectureViolationsConfiguration configuration = new ArchitectureViolationsConfiguration(selectedTestResult);
        this.violatingDependencies = configuration.violationsByDescription();
        this.classes = configuration.importClasses();
        this.codeProjectController.exploreConfiguration(configuration);
    }

    ArchitectureViolations getSelectedViolations() {
        return this.selectedTestResultIndex == -1 ? null : this.getTestResult(this.selectedTestResultIndex);
    }

    private ArchitectureViolations getTestResult(int selectedTestResultIndex) {
        List<ArchitectureViolations> submittedTestResults = this.submittedTestResults();
        if (selectedTestResultIndex >= 0 && selectedTestResultIndex < submittedTestResults.size()) {
            return submittedTestResults.get(selectedTestResultIndex);
        }
        return null;
    }

    private List<ArchitectureViolations> submittedTestResults() {
        return this.archUnitServer.getSubmittedTestResults();
    }

    private void addNewTestResult(String violatedRuleDescription) {
        this.ruleTableModel.addRow(new Object[]{violatedRuleDescription});
        int row = this.ruleTable.getRowCount() - 1;
        if (row == 0) {
            this.ruleTable.changeSelection(row, 0, false, false);
        }
    }

    private void deleteSelectedTestResults() {
        int maxSelectionIndex;
        ListSelectionModel selectionModel = this.ruleTable.getSelectionModel();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        if (minSelectionIndex == -1) {
            return;
        }
        for (int row = maxSelectionIndex = selectionModel.getMaxSelectionIndex(); row >= minSelectionIndex; --row) {
            this.ruleTableModel.removeRow(row);
            this.submittedTestResults().remove(row);
        }
        int rowCount = this.ruleTableModel.getRowCount();
        if (minSelectionIndex < rowCount) {
            this.ruleTable.changeSelection(minSelectionIndex, 0, false, false);
        } else if (rowCount > 0) {
            this.ruleTable.changeSelection(rowCount - 1, 0, false, false);
        }
        this.updateViolations();
    }

    private void cancelAnalysis() {
        this.codeProjectController.cancelAnalysis();
    }

    private void createPanels(AFreeplaneAction enableServerAction) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel rulesLabel = new JLabel(TextUtils.getText((String)"code.rules"));
        JComponent rulesPanel = this.createRulePanel();
        JComponent ruleTableToolbar = this.createRuleTableToolbar(enableServerAction);
        JLabel violationsLabel = new JLabel(TextUtils.getText((String)"code.violations"));
        JComponent violationsPane = this.createViolationsPane();
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        this.add((Component)rulesLabel, gbc);
        gbc.gridy = 1;
        gbc.anchor = 21;
        this.add((Component)ruleTableToolbar, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 10;
        this.add((Component)violationsLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 1;
        rulesPanel.setPreferredSize(new Dimension(1, 1));
        this.add((Component)rulesPanel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 2.0;
        violationsPane.setPreferredSize(new Dimension(1, 1));
        this.add((Component)violationsPane, gbc);
    }

    private JComponent createRuleTableToolbar(AFreeplaneAction enableServerAction) {
        FreeplaneToolBar toolbar = new FreeplaneToolBar(0);
        AbstractButton enableServerButton = FreeplaneToolBar.createButton((AFreeplaneAction)enableServerAction);
        JButton deleteTestResultButton = TranslatedElementFactory.createButtonWithIcon((String)"code.DeleteConfigurationsAction.icon", (String)"code.DeleteConfigurationsAction.text");
        deleteTestResultButton.addActionListener(e -> this.deleteSelectedTestResults());
        JButton exploreTestResultButton = TranslatedElementFactory.createButtonWithIcon((String)"code.explore.icon", (String)"code.explore");
        exploreTestResultButton.addActionListener(e -> this.exploreSelectedTestResult());
        this.ruleTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    ArchitectureViolationsPanel.this.exploreSelectedTestResult();
                }
            }
        });
        JButton cancelButton = TranslatedElementFactory.createButtonWithIcon((String)"code.cancel.icon", (String)"code.cancel");
        cancelButton.addActionListener(e -> this.cancelAnalysis());
        JComponent[] panelButtons = new JComponent[]{enableServerButton, deleteTestResultButton, exploreTestResultButton, cancelButton};
        Stream.of(panelButtons).forEach(button -> toolbar.add((Component)button));
        JButton[] enablingButtons = new JButton[]{exploreTestResultButton};
        Stream.of(enablingButtons).forEach(button -> button.setEnabled(false));
        Runnable enableButtons = () -> {
            int selectedRowCount = this.ruleTable.getSelectedRowCount();
            deleteTestResultButton.setEnabled(selectedRowCount >= 1);
            boolean enable = selectedRowCount == 1;
            Stream.of(enablingButtons).forEach(button -> button.setEnabled(enable));
        };
        this.ruleTable.getSelectionModel().addListSelectionListener(l -> enableButtons.run());
        return toolbar;
    }

    void addDependencySelectionCallback(final Consumer<Object> listener) {
        this.violationTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                listener.accept(this);
            }
        });
        this.violationTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    listener.accept(this);
                }
            }
        });
    }

    public Set<JavaClass> getSelectedClasses() {
        if (this.exploredTestResultIndex == -1 || this.exploredTestResultIndex != this.selectedTestResultIndex) {
            return Collections.emptySet();
        }
        Stream selectedDependencies = this.violatingDependencies.isEmpty() ? Stream.empty() : IntStream.of(this.violationTable.getSelectedRows()).map(this.violationTable::convertRowIndexToModel).mapToObj(row -> (ViolationDescription)this.selectedViolations.getViolationDescriptions().get(row)).flatMap(x -> Stream.concat(x.getViolationDependencyDescriptions().stream(), x.getCyclicDependencyDescriptions().stream())).map(this.violatingDependencies::get).filter(x -> x != null).flatMap(d -> Stream.of(d.getOriginClass(), d.getTargetClass()));
        Stream<JavaClass> selectedClasses = IntStream.of(this.violationTable.getSelectedRows()).map(this.violationTable::convertRowIndexToModel).mapToObj(row -> ((ViolationDescription)this.selectedViolations.getViolationDescriptions().get(row)).getViolatingClasses()).flatMap(Collection::stream).filter(arg_0 -> ((JavaClasses)this.classes).contain(arg_0)).map(arg_0 -> ((JavaClasses)this.classes).get(arg_0));
        return Stream.concat(selectedDependencies, selectedClasses).collect(Collectors.toSet());
    }
}

