/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.mindmapmode.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import org.freeplane.core.resources.components.BooleanProperty;
import org.freeplane.core.resources.components.FontProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.link.mindmapmode.editor.ControlGroup;
import org.freeplane.features.link.mindmapmode.editor.ControlGroupChangeListener;

public class FontNameControlGroup
implements ControlGroup {
    private static final String NODE_FONT_NAME = "nodefontname";
    private BooleanProperty mSetNodeFontName;
    private FontProperty mNodeFontName;
    private FontNameChangeListener propertyChangeListener;
    private ConnectorModel connector;

    @Override
    public void updateValue(ConnectorModel connector) {
        this.connector = connector;
        this.propertyChangeListener.update();
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetNodeFontName = new BooleanProperty("set_property_text");
        this.mNodeFontName = new FontProperty(NODE_FONT_NAME);
        this.propertyChangeListener = new FontNameChangeListener(this.mSetNodeFontName, (IPropertyControl)this.mNodeFontName);
        this.mSetNodeFontName.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mNodeFontName.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mSetNodeFontName.appendToForm(formBuilder);
        this.mNodeFontName.appendToForm(formBuilder);
    }

    private class FontNameChangeListener
    extends ControlGroupChangeListener {
        public FontNameChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, PropertyChangeEvent evt) {
            MLinkController linkController = (MLinkController)LinkController.getController();
            linkController.setLabelFontFamily(FontNameControlGroup.this.connector, enabled ? Optional.of(FontNameControlGroup.this.mNodeFontName.getValue()) : Optional.empty());
        }

        @Override
        void updateValue() {
            LinkController linkController = LinkController.getController();
            Optional fontFamilyName = FontNameControlGroup.this.connector.getLabelFontFamily();
            String viewFontFamilyName = linkController.getLabelFontFamily(FontNameControlGroup.this.connector);
            FontNameControlGroup.this.mSetNodeFontName.setValue(fontFamilyName.isPresent());
            FontNameControlGroup.this.mNodeFontName.setValue(viewFontFamilyName);
        }
    }
}

