/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;
import org.freeplane.view.swing.map.outline.BlockPanel;
import org.freeplane.view.swing.map.outline.BreadcrumbPanel;
import org.freeplane.view.swing.map.outline.NodeButton;
import org.freeplane.view.swing.map.outline.OutlinePane;
import org.freeplane.view.swing.map.outline.OutlineSelection;
import org.freeplane.view.swing.map.outline.ScrollableTreePanel;
import org.freeplane.view.swing.map.outline.TreeNode;

class OutlineFocusManager {
    private final ScrollableTreePanel panel;
    private final BreadcrumbPanel breadcrumbPanel;
    private final OutlineSelection outlineSelection;

    OutlineFocusManager(ScrollableTreePanel panel, BreadcrumbPanel breadcrumbPanel, OutlineSelection outlineSelection) {
        this.panel = panel;
        this.breadcrumbPanel = breadcrumbPanel;
        this.outlineSelection = outlineSelection;
    }

    boolean isWithinOutline(Component c) {
        if (c == null) {
            return false;
        }
        return SwingUtilities.isDescendingFrom(c, this.panel) || SwingUtilities.isDescendingFrom(c, this.breadcrumbPanel);
    }

    boolean isNodeButtonFocused() {
        Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
        Container outlinePane = SwingUtilities.getAncestorOfClass(OutlinePane.class, this.panel);
        boolean wasFocused = focusOwner instanceof NodeButton && outlinePane != null && SwingUtilities.isDescendingFrom(focusOwner, outlinePane);
        return wasFocused;
    }

    void focusSelectionButtonLater(boolean requestFocus) {
        SwingUtilities.invokeLater(() -> this.focusSelectionButton(requestFocus));
    }

    void focusSelectionButton(boolean requestFocusInWindow) {
        TreeNode selected;
        TreeNode treeNode = selected = this.outlineSelection != null ? this.outlineSelection.getSelectedNode() : null;
        if (selected == null) {
            return;
        }
        if (!requestFocusInWindow) {
            Container focusOwner = FocusManager.getCurrentManager().getCurrentFocusCycleRoot();
            if (focusOwner == null) {
                return;
            }
            if (!SwingUtilities.isDescendingFrom(focusOwner, this.panel)) {
                return;
            }
        }
        boolean isSelectionDrivenBreadcrumbMode = this.panel.isSelectionDrivenBreadcrumbMode();
        for (TreeNode n = this.outlineSelection.getSelectedNode(); n != null; n = n.getParent()) {
            if (!isSelectionDrivenBreadcrumbMode && this.focusButtonInBreadcrumbForNode(n)) {
                return;
            }
            if (this.focusButtonInBlocksForNode(n)) {
                return;
            }
            if (!isSelectionDrivenBreadcrumbMode || !this.focusButtonInBreadcrumbForNode(n)) continue;
            return;
        }
    }

    void restoreFocusIfNeeded(boolean previousWasInOutline) {
        TreeNode selected;
        if (!previousWasInOutline) {
            return;
        }
        Window w = SwingUtilities.getWindowAncestor(this.panel);
        if (w == null || !w.isDisplayable()) {
            return;
        }
        Component current = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (this.isWithinOutline(current)) {
            return;
        }
        TreeNode treeNode = selected = this.outlineSelection != null ? this.outlineSelection.getSelectedNode() : null;
        if (selected != null) {
            for (Component comp : this.breadcrumbPanel.getComponents()) {
                NodeButton btn;
                if (!(comp instanceof NodeButton) || (btn = (NodeButton)comp).getNode() != selected || !btn.isShowing()) continue;
                btn.requestFocusInWindow();
                return;
            }
            for (BlockPanel panel : this.panel.getBlockPanels()) {
                for (Component comp : panel.getComponents()) {
                    NodeButton btn;
                    if (!(comp instanceof NodeButton) || (btn = (NodeButton)comp).getNode() != selected || !btn.isShowing()) continue;
                    btn.requestFocusInWindow();
                    return;
                }
            }
        }
        if (this.panel.isShowing()) {
            this.panel.requestFocusInWindow();
        }
    }

    private boolean focusButtonInBreadcrumbForNode(TreeNode node) {
        if (node == null) {
            return false;
        }
        for (Component comp : this.breadcrumbPanel.getComponents()) {
            NodeButton btn;
            if (!(comp instanceof NodeButton) || (btn = (NodeButton)comp).getNode() != node || !btn.isShowing()) continue;
            btn.requestFocusInWindow();
            return true;
        }
        return false;
    }

    private boolean focusButtonInBlocksForNode(TreeNode node) {
        if (node == null) {
            return false;
        }
        for (BlockPanel panel : this.panel.getBlockPanels()) {
            for (Component comp : panel.getComponents()) {
                NodeButton btn;
                if (!(comp instanceof NodeButton) || (btn = (NodeButton)comp).getNode() != node || !btn.isShowing()) continue;
                btn.requestFocusInWindow();
                return true;
            }
        }
        return false;
    }
}

