/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.view.swing.map.outline.BreadcrumbPanel;
import org.freeplane.view.swing.map.outline.MapTreeNode;
import org.freeplane.view.swing.map.outline.OutlineActionTargetProvider;
import org.freeplane.view.swing.map.outline.OutlineActions;
import org.freeplane.view.swing.map.outline.OutlineController;
import org.freeplane.view.swing.map.outline.OutlineDisplayMode;
import org.freeplane.view.swing.map.outline.OutlineGeometry;
import org.freeplane.view.swing.map.outline.ScrollableTreePanel;
import org.freeplane.view.swing.map.outline.TreeNode;

class OutlinePane
extends JPanel
implements OutlineActionTargetProvider {
    private static final long serialVersionUID = 1L;
    private static final int SCROLL_INACTIVITY_DELAY_MS = 200;
    private JScrollPane treeScrollPane;
    private ScrollableTreePanel treePanel;
    private BreadcrumbPanel breadcrumbPanel = new BreadcrumbPanel();
    private JPopupMenu actionMenu;
    private OutlineActions actions;
    private OutlineController controller;
    private Rectangle lastBreadcrumbBounds;
    protected FreeplaneToolBar toolbar;

    OutlinePane(OutlineDisplayMode displayMode, TreeNode rootNode) {
        this.treePanel = new ScrollableTreePanel(displayMode, rootNode, this.breadcrumbPanel);
        this.breadcrumbPanel.setBackgroundColorSupplier(this.treePanel::getBackground);
        this.treeScrollPane = new JScrollPane(this.treePanel);
        UITools.setScrollbarIncrement(this.treeScrollPane);
        this.treePanel.setScrollPane(this.treeScrollPane);
        this.controller = new OutlineController(this.treePanel, this.treeScrollPane);
        this.breadcrumbPanel.initialize(this.controller, this.treePanel.getOutlineSelection());
        this.actions = new OutlineActions(this);
        this.actionMenu = this.actions.buildMenuLocalized();
        this.toolbar = new FreeplaneToolBar(0);
        this.configureToolbar(this.toolbar);
        JPanel topBarContainer = new JPanel(new BorderLayout());
        topBarContainer.add(Box.createHorizontalGlue(), "Center");
        topBarContainer.add((Component)this.toolbar, "West");
        this.setLayout(new BorderLayout(0, 0){
            private static final long serialVersionUID = 1L;

            @Override
            public void layoutContainer(Container parent) {
                int oldScrollPaneWidth = OutlinePane.this.treeScrollPane.getWidth();
                super.layoutContainer(parent);
                OutlinePane.this.treeScrollPane.validate();
                Rectangle r = new Rectangle();
                Rectangle vpBorder = SwingUtilities.convertRectangle(OutlinePane.this.treeScrollPane, OutlinePane.this.treeScrollPane.getViewportBorderBounds(), OutlinePane.this);
                Insets viewportInsets = OutlinePane.this.treeScrollPane.getViewport().getInsets();
                int x = vpBorder.x + viewportInsets.left;
                int y = vpBorder.y + viewportInsets.top;
                int w = Math.max(0, vpBorder.width - viewportInsets.left - viewportInsets.right);
                int h = OutlinePane.this.breadcrumbPanel.getPreferredBreadcrumbHeight();
                r.x = x;
                r.y = y;
                r.width = w;
                r.height = h;
                if (OutlinePane.this.lastBreadcrumbBounds == null || !OutlinePane.this.lastBreadcrumbBounds.equals(r)) {
                    OutlinePane.this.lastBreadcrumbBounds = new Rectangle(r);
                }
                OutlinePane.this.breadcrumbPanel.setBounds(r);
                if (oldScrollPaneWidth != OutlinePane.this.treeScrollPane.getWidth()) {
                    JViewport viewport = OutlinePane.this.treeScrollPane.getViewport();
                    OutlineGeometry geometry = OutlineGeometry.getInstance();
                    Component view = viewport.getView();
                    Point viewPosition = new Point(geometry.isRightToLeft() ? view.getWidth() - viewport.getWidth() : 0, -view.getY());
                    viewport.setViewPosition(viewPosition);
                }
            }
        });
        this.add((Component)topBarContainer, "North");
        this.add(this.breadcrumbPanel);
        this.add((Component)this.treeScrollPane, "Center");
        this.setupScrollListeners();
    }

    private void configureToolbar(FreeplaneToolBar toolbar) {
        JButton menuButton = new JButton("\u2261");
        TranslatedElementFactory.createTooltip(menuButton, "outline.menu.tooltip");
        menuButton.addActionListener(e -> {
            TreeNode selected = this.treePanel.getOutlineSelection().getSelectedNode();
            boolean hasParent = selected != null && selected.getParent() != null;
            boolean hasChild = selected != null && !selected.getChildren().isEmpty();
            boolean canToggle = selected != null && hasChild && selected.getLevel() > 0;
            this.actions.selectInMap.setEnabled(selected != null);
            this.actions.goLeft.setEnabled(hasParent);
            this.actions.goRight.setEnabled(hasChild);
            this.actions.toggleExpand.setEnabled(canToggle);
            this.actionMenu.show(menuButton, 0, menuButton.getHeight());
        });
        toolbar.add(menuButton);
    }

    ScrollableTreePanel getTreePanel() {
        return this.treePanel;
    }

    void updateNodeTitleLater(TreeNode node) {
        SwingUtilities.invokeLater(() -> this.updateNodeTitle(node));
    }

    void updateNodeTitle(TreeNode node) {
        this.treePanel.updateNodeTitle(node);
    }

    void rebuildFromNode(TreeNode node) {
        this.treePanel.rebuildFromNode(node.getId());
    }

    void setRootNode(OutlineDisplayMode displayMode, TreeNode newRootNode) {
        TreeNode oldRoot;
        if (this.treePanel != null && (oldRoot = this.treePanel.getRoot()) != null) {
            OutlinePane.cleanupTree(oldRoot);
        }
        this.remove(this.treeScrollPane);
        this.remove(this.breadcrumbPanel);
        BreadcrumbPanel newBreadcrumbPanel = new BreadcrumbPanel();
        ScrollableTreePanel newTreePanel = new ScrollableTreePanel(displayMode, newRootNode, newBreadcrumbPanel);
        newBreadcrumbPanel.setBackgroundColorSupplier(newTreePanel::getBackground);
        JScrollPane newScrollPane = new JScrollPane(newTreePanel);
        UITools.setScrollbarIncrement(newScrollPane);
        newTreePanel.setScrollPane(newScrollPane);
        this.controller = new OutlineController(newTreePanel, newScrollPane);
        newBreadcrumbPanel.initialize(this.controller, newTreePanel.getOutlineSelection());
        this.treePanel = newTreePanel;
        this.treeScrollPane = newScrollPane;
        this.breadcrumbPanel = newBreadcrumbPanel;
        this.add(this.breadcrumbPanel);
        this.add((Component)this.treeScrollPane, "Center");
        this.setupScrollListeners();
        this.performInitialSetup();
        this.revalidate();
        this.repaint();
    }

    @Override
    public OutlineController getController() {
        return this.controller;
    }

    private void setupScrollListeners() {
        Timer scrollDebounceTimer = new Timer(200, e2 -> this.treePanel.updateVisibleBlocksAndBreadcrumb());
        scrollDebounceTimer.setRepeats(false);
        this.treeScrollPane.getVerticalScrollBar().addAdjustmentListener(e -> {
            this.treePanel.updateVisibleBlocks();
            if (!this.treePanel.isSelectionDrivenBreadcrumbMode()) {
                scrollDebounceTimer.restart();
            }
        });
        this.treeScrollPane.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                OutlinePane.this.treePanel.updateVisibleBlocks();
            }
        });
    }

    private void performInitialSetup() {
        SwingUtilities.invokeLater(() -> this.treePanel.performInitialSetup());
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    static void cleanupTree(TreeNode rootTreeNode) {
        if (rootTreeNode instanceof MapTreeNode) {
            ((MapTreeNode)rootTreeNode).cleanupListeners();
        }
    }

    boolean isSelected(TreeNode node) {
        return this.treePanel.getOutlineSelection().isSelected(node);
    }

    OutlineDisplayMode getDisplayMode() {
        return OutlineDisplayMode.DEFAULT;
    }
}

