/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import java.util.ArrayList;
import java.util.List;
import org.freeplane.plugin.ai.chat.AssistantProfileSwitchMessage;
import org.freeplane.plugin.ai.chat.LiveChatSession;
import org.freeplane.plugin.ai.chat.history.AssistantProfileTranscriptEntry;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptEntry;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptRole;

class LiveTranscriptAdapter {
    LiveTranscriptAdapter() {
    }

    void appendUserMessage(LiveChatSession session, String text) {
        this.appendEntry(session, ChatTranscriptRole.USER, text);
    }

    void appendAssistantMessage(LiveChatSession session, String text) {
        this.appendEntry(session, ChatTranscriptRole.ASSISTANT, text);
    }

    void appendAssistantProfileMessage(LiveChatSession session, AssistantProfileSwitchMessage message) {
        if (session == null || message == null) {
            return;
        }
        List<ChatTranscriptEntry> entries = session.getTranscriptEntries();
        if (entries == null) {
            entries = new ArrayList<ChatTranscriptEntry>();
            session.setTranscriptEntries(entries);
        }
        AssistantProfileTranscriptEntry entry = new AssistantProfileTranscriptEntry(message.getProfileId(), message.getProfileName(), false);
        entries.add(entry);
    }

    void setEntries(LiveChatSession session, List<ChatTranscriptEntry> entries) {
        if (session == null) {
            return;
        }
        if (entries == null) {
            session.setTranscriptEntries(new ArrayList<ChatTranscriptEntry>());
        } else {
            session.setTranscriptEntries(new ArrayList<ChatTranscriptEntry>(entries));
        }
    }

    private void appendEntry(LiveChatSession session, ChatTranscriptRole role, String text) {
        if (session == null || text == null) {
            return;
        }
        List<ChatTranscriptEntry> entries = session.getTranscriptEntries();
        if (entries == null) {
            entries = new ArrayList<ChatTranscriptEntry>();
            session.setTranscriptEntries(entries);
        }
        entries.add(new ChatTranscriptEntry(role, text));
    }
}

