/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharBox;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.CharSymbol;
import org.scilab.forge.jlatexmath.ScaleBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;

public class CharAtom
extends CharSymbol {
    private final char c;
    private String textStyle;
    private boolean mathMode;

    public CharAtom(char c, String textStyle, boolean mathMode) {
        this.c = c;
        this.textStyle = textStyle;
        this.mathMode = mathMode;
    }

    public CharAtom(char c, String textStyle) {
        this(c, textStyle, false);
    }

    public boolean isMathMode() {
        return this.mathMode;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        String ts;
        if (this.textStyle == null && (ts = env.getTextStyle()) != null) {
            this.textStyle = ts;
        }
        boolean smallCap = env.getSmallCap();
        Char ch = this.getChar(env.getTeXFont(), env.getStyle(), smallCap);
        Box box = new CharBox(ch);
        if (smallCap && Character.isLowerCase(this.c)) {
            box = new ScaleBox(box, 0.8f, 0.8f);
        }
        return box;
    }

    public char getCharacter() {
        return this.c;
    }

    private Char getChar(TeXFont tf, int style, boolean smallCap) {
        char chr = this.c;
        if (smallCap && Character.isLowerCase(this.c)) {
            chr = Character.toUpperCase(this.c);
        }
        if (this.textStyle == null) {
            return tf.getDefaultChar(chr, style);
        }
        return tf.getChar(chr, this.textStyle, style);
    }

    @Override
    public CharFont getCharFont(TeXFont tf) {
        return this.getChar(tf, 0, false).getCharFont();
    }

    public String toString() {
        return "CharAtom: '" + this.c + "'";
    }
}

