/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldHighlightFactory;
import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.plugin.core.byteviewer.ByteField;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.byteviewer.ByteViewerHighlighter;
import ghidra.app.plugin.core.byteviewer.IndexMap;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.ByteBlockSet;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.app.plugin.core.format.IndexedByteBlockInfo;
import ghidra.program.model.address.AddressOutOfBoundsException;
import java.awt.Color;
import java.awt.FontMetrics;
import java.math.BigInteger;

class FieldFactory {
    private IndexMap indexMap;
    private ByteBlockSet blockSet;
    private DataFormatModel model;
    private int charWidth;
    private int fieldOffset;
    private FontMetrics fm;
    private int width;
    private String noValueStr;
    private String readErrorStr;
    private int startX;
    private Color editColor;
    private Color separatorColor;
    private int unitByteSize;
    private FieldHighlightFactory highlightFactory;

    FieldFactory(DataFormatModel model, int bytesPerLine, int fieldOffset, FontMetrics fm, ByteViewerHighlighter highlightProvider) {
        this.model = model;
        this.fieldOffset = fieldOffset;
        this.fm = fm;
        this.highlightFactory = new SimpleHighlightFactory(highlightProvider);
        this.charWidth = fm.charWidth('W');
        this.width = this.charWidth * model.getDataUnitSymbolSize();
        this.editColor = ByteViewerComponentProvider.CHANGED_VALUE_COLOR;
        this.separatorColor = ByteViewerComponentProvider.SEPARATOR_COLOR;
        this.unitByteSize = model.getUnitByteSize();
    }

    public void setStartX(int x) {
        this.startX = x;
    }

    public int getStartX() {
        return this.startX;
    }

    public boolean isActive(BigInteger index) {
        if (this.indexMap == null) {
            return false;
        }
        return this.indexMap.getBlockInfo(index, this.fieldOffset) != null;
    }

    public Field getField(BigInteger index) {
        if (this.indexMap == null) {
            return null;
        }
        IndexedByteBlockInfo info = this.indexMap.getBlockInfo(index, this.fieldOffset);
        if (info == null) {
            if (this.indexMap.isBlockSeparatorIndex(index)) {
                ByteField bf = new ByteField(this.noValueStr, this.fm, this.startX, this.width, false, this.fieldOffset, index, this.highlightFactory);
                bf.setForeground(this.separatorColor);
                return bf;
            }
            return null;
        }
        try {
            ByteBlock block = info.getBlock();
            BigInteger offset = info.getOffset();
            if (!block.hasValue(offset)) {
                return this.getByteField(this.readErrorStr, index);
            }
            String str = this.model.getDataRepresentation(block, offset);
            ByteField bf = new ByteField(str, this.fm, this.startX, this.width, false, this.fieldOffset, index, this.highlightFactory);
            if (this.blockSet.isChanged(block, offset, this.unitByteSize)) {
                bf.setForeground(this.editColor);
            }
            return bf;
        }
        catch (ByteBlockAccessException e) {
            return this.getByteField(this.readErrorStr, index);
        }
        catch (AddressOutOfBoundsException e) {
            return this.getByteField(this.noValueStr, index);
        }
        catch (IndexOutOfBoundsException e) {
            return this.getByteField(this.noValueStr, index);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public FontMetrics getMetrics() {
        return this.fm;
    }

    void setIndexMap(IndexMap indexMap) {
        this.indexMap = indexMap;
        if (indexMap != null) {
            this.noValueStr = this.getString(".");
            this.readErrorStr = this.getString("?");
            this.blockSet = indexMap.getByteBlockSet();
        } else {
            this.blockSet = null;
        }
    }

    int getFieldOffset() {
        return this.fieldOffset;
    }

    int getColumnPosition(ByteBlock block, int byteOffset) {
        return this.model.getColumnPosition(block, byteOffset);
    }

    void setEditColor(Color c) {
        this.editColor = c;
    }

    void setSeparatorColor(Color c) {
        this.separatorColor = c;
    }

    private String getString(String value) {
        StringBuffer sb = new StringBuffer();
        int count = this.model.getDataUnitSymbolSize();
        for (int i = 0; i < count; ++i) {
            sb.append(value);
        }
        return sb.toString();
    }

    private ByteField getByteField(String value, BigInteger index) {
        return new ByteField(value, this.fm, this.startX, this.width, false, this.fieldOffset, index, this.highlightFactory);
    }

    static class SimpleHighlightFactory
    implements FieldHighlightFactory {
        private final ByteViewerHighlighter provider;

        public SimpleHighlightFactory(ByteViewerHighlighter provider) {
            this.provider = provider;
        }

        public Highlight[] createHighlights(Field field, String text, int cursorTextOffset) {
            return this.provider.createHighlights(text);
        }
    }
}

