/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.module;

import ghidra.framework.cmd.Command;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.DuplicateNameException;

public class CreateDefaultTreeCmd
implements Command<Program> {
    private String treeName;
    private String statusMsg;

    public CreateDefaultTreeCmd(String treeName) {
        this.treeName = treeName;
    }

    public boolean applyTo(Program program) {
        Listing listing = program.getListing();
        try {
            listing.createRootModule(this.treeName);
            CreateDefaultTreeCmd.renameFragments(program, this.treeName);
            return true;
        }
        catch (DuplicateNameException e) {
            this.statusMsg = e.getMessage();
            return false;
        }
    }

    static ProgramModule createRootModule(Program program, String treeName) throws DuplicateNameException {
        Listing listing = program.getListing();
        ProgramModule root = listing.createRootModule(treeName);
        CreateDefaultTreeCmd.renameFragments(program, treeName);
        return root;
    }

    private static void renameFragments(Program program, String treeName) {
        MemoryBlock[] blocks;
        Listing listing = program.getListing();
        for (MemoryBlock block : blocks = program.getMemory().getBlocks()) {
            ProgramFragment fragment = listing.getFragment(treeName, block.getStart());
            try {
                fragment.setName(block.getName());
            }
            catch (DuplicateNameException duplicateNameException) {
                // empty catch block
            }
        }
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    public String getName() {
        return "Create Tree " + this.treeName;
    }
}

