/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.StandAloneDataTypeManager;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractUndoRedoArchiveTransactionAction
extends DockingAction {
    private String actionName;

    public AbstractUndoRedoArchiveTransactionAction(String actionName, DataTypeManagerPlugin plugin) {
        super(actionName + " Archive Change", plugin.getName());
        this.actionName = actionName;
        this.setPopupMenuData(this.getMenuData(null));
        this.setEnabled(true);
    }

    private MenuData getMenuData(String txName) {
        String name = this.actionName + " Change";
        if (!StringUtils.isEmpty((CharSequence)txName)) {
            name = name + ": " + txName;
        }
        return new MenuData(new String[]{name}, null, "FileEdit");
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        TreePath[] selectionPaths = this.getSelectionPaths(context);
        return this.getModifiableProjectOrFileDTM(selectionPaths) != null;
    }

    protected abstract boolean canExecute(StandAloneDataTypeManager var1);

    protected abstract String getNextName(StandAloneDataTypeManager var1);

    protected abstract void execute(StandAloneDataTypeManager var1);

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        TreePath[] selectionPaths = this.getSelectionPaths(context);
        StandAloneDataTypeManager dtm = this.getModifiableProjectOrFileDTM(selectionPaths);
        if (dtm != null && this.canExecute(dtm)) {
            this.setPopupMenuData(this.getMenuData(this.getNextName(dtm)));
            return true;
        }
        this.setPopupMenuData(this.getMenuData(null));
        return false;
    }

    public void actionPerformed(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return;
        }
        TreePath[] selectionPaths = this.getSelectionPaths(context);
        StandAloneDataTypeManager dtm = this.getModifiableProjectOrFileDTM(selectionPaths);
        if (dtm != null && this.canExecute(dtm)) {
            this.execute(dtm);
        }
    }

    private TreePath[] getSelectionPaths(ActionContext context) {
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        return selectionPaths;
    }

    private StandAloneDataTypeManager getModifiableProjectOrFileDTM(TreePath[] selectionPaths) {
        DataTypeManager dtm;
        if (selectionPaths.length != 1) {
            return null;
        }
        TreePath path = selectionPaths[0];
        if (path.getPathCount() < 2) {
            return null;
        }
        GTreeNode node = (GTreeNode)path.getPathComponent(1);
        if (!(node instanceof FileArchiveNode) && !(node instanceof ProjectArchiveNode)) {
            return null;
        }
        ArchiveNode archiveNode = (ArchiveNode)node;
        if (archiveNode.isModifiable() && (dtm = archiveNode.getArchive().getDataTypeManager()) instanceof StandAloneDataTypeManager) {
            StandAloneDataTypeManager archiveDtm = (StandAloneDataTypeManager)dtm;
            return archiveDtm;
        }
        return null;
    }
}

