/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyState;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyTreeResolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class AssemblyOperandState
extends AbstractAssemblyState {
    protected final AssemblyTerminal terminal;
    protected final long value;
    protected final OperandSymbol opSym;

    public AssemblyOperandState(AbstractAssemblyTreeResolver<?> resolver, List<AssemblyConstructorSemantic> path, int shift, AssemblyTerminal terminal, long value, OperandSymbol opSym) {
        super(resolver, path, shift, opSym.getMinimumLength());
        this.terminal = terminal;
        this.value = value;
        this.opSym = opSym;
    }

    @Override
    public int computeHash() {
        int result = this.getClass().hashCode();
        result *= 31;
        result += Integer.hashCode(this.shift);
        result *= 31;
        result += Long.hashCode(this.value);
        result *= 31;
        return result += this.opSym.hashCode();
    }

    protected boolean partsEqual(AssemblyOperandState that) {
        if (this.resolver != that.resolver) {
            return false;
        }
        if (this.shift != that.shift) {
            return false;
        }
        if (this.value != that.value) {
            return false;
        }
        return Objects.equals(this.opSym, that.opSym);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssemblyOperandState that = (AssemblyOperandState)obj;
        return this.partsEqual(that);
    }

    public String toString() {
        return String.valueOf(this.terminal) + "=" + this.value + "(0x" + Long.toHexString(this.value) + ")";
    }

    protected int computeBitsize() {
        if (!(this.terminal instanceof AssemblyNumericTerminal)) {
            return 0;
        }
        AssemblyNumericTerminal numeric = (AssemblyNumericTerminal)this.terminal;
        return numeric.getBitSize();
    }

    protected AssemblyResolution solveNumeric() {
        int bitsize = this.computeBitsize();
        PatternExpression symExp = this.opSym.getDefiningExpression();
        if (symExp == null) {
            symExp = this.opSym.getDefiningSymbol().getPatternExpression();
        }
        String desc = "Solution to " + String.valueOf(this.opSym) + " in " + Long.toHexString(this.value) + " = " + String.valueOf(symExp);
        AssemblyResolution sol = this.factory.solveOrBackfill(symExp, this.value, bitsize, this.resolver.vals, null, desc);
        AssemblyResolution shifted = sol.shift(this.shift);
        return shifted;
    }

    @Override
    protected Stream<AssemblyResolvedPatterns> resolve(AssemblyResolvedPatterns fromRight, Collection<AssemblyResolvedError> errors) {
        AssemblyResolution sol = this.solveNumeric();
        if (sol.isError()) {
            errors.add((AssemblyResolvedError)sol);
            return Stream.of(new AssemblyResolvedPatterns[0]);
        }
        if (sol.isBackfill()) {
            AssemblyResolvedPatterns combined = fromRight.combine((AssemblyResolvedBackfill)sol);
            return Stream.of(combined.withRight(fromRight));
        }
        AssemblyResolvedPatterns combined = fromRight.combine((AssemblyResolvedPatterns)sol);
        if (combined == null) {
            errors.add(((AbstractAssemblyResolutionFactory.AssemblyResolvedErrorBuilder)this.factory.newErrorBuilder().error("Pattern/operand conflict").description("Resolving " + String.valueOf(this.terminal))).build());
            return Stream.of(new AssemblyResolvedPatterns[0]);
        }
        AssemblyResolvedPatterns pats = combined;
        return Stream.of(pats.withRight(fromRight).withConstructor(null));
    }

    public AssemblyTerminal getTerminal() {
        return this.terminal;
    }

    public long getValue() {
        return this.value;
    }

    public OperandSymbol getOperandSymbol() {
        return this.opSym;
    }
}

