/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.GenericAddress;

public class OldGenericNamespaceAddress
extends GenericAddress {
    public static final long OLD_MIN_NAMESPACE_ID = 1L;
    public static final long OLD_MAX_NAMESPACE_ID = 0xFFFFFFFL;
    long namespaceID;

    public OldGenericNamespaceAddress(AddressSpace addrSpace, long offset, long namespaceID) {
        super(addrSpace, offset);
        if (namespaceID < 0L || namespaceID > 0xFFFFFFFL) {
            throw new IllegalArgumentException("namespaceID too large");
        }
        this.namespaceID = namespaceID;
    }

    public long getNamespaceID() {
        return this.namespaceID;
    }

    public Address getGlobalAddress() {
        return this.addrSpace.getAddress(this.offset);
    }

    public static Address getMinAddress(AddressSpace addrSpace, long namespaceID) {
        return new OldGenericNamespaceAddress(addrSpace, 0L, namespaceID);
    }

    public static Address getMaxAddress(AddressSpace addrSpace, long namespaceID) {
        if (addrSpace.isStackSpace()) {
            return new OldGenericNamespaceAddress(addrSpace, -1L, namespaceID);
        }
        return new OldGenericNamespaceAddress(addrSpace, addrSpace.getMaxAddress().getOffset(), namespaceID);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OldGenericNamespaceAddress)) {
            return false;
        }
        OldGenericNamespaceAddress addr = (OldGenericNamespaceAddress)o;
        return this.addrSpace.equals(addr.getAddressSpace()) && this.namespaceID == addr.namespaceID && this.offset == addr.offset;
    }
}

