/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout.flowchart;

import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.ColumnSegment;
import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.EdgeSegment;
import ghidra.graph.viewer.layout.GridPoint;
import java.util.List;

public class RowSegment<E>
extends EdgeSegment<E> {
    private ColumnSegment<E> next;
    private ColumnSegment<E> previous;

    RowSegment(ColumnSegment<E> previous, E e, List<GridPoint> points, int pointIndex) {
        super(e, points, pointIndex);
        this.previous = previous;
        this.next = new ColumnSegment<E>(this, e, points, pointIndex + 1);
    }

    public int getRow() {
        return ((GridPoint)this.points.get((int)this.pointIndex)).row;
    }

    public int getStartCol() {
        return ((GridPoint)this.points.get((int)this.pointIndex)).col;
    }

    public int getEndCol() {
        return ((GridPoint)this.points.get((int)(this.pointIndex + 1))).col;
    }

    public int getLeftCol() {
        return Math.min(this.getStartCol(), this.getEndCol());
    }

    public int getRightCol() {
        return Math.max(this.getStartCol(), this.getEndCol());
    }

    public int compareToIgnoreFlows(RowSegment<E> other) {
        int result = this.compareLefts(other);
        if (result == 0) {
            result = this.compareRights(other);
        }
        return result;
    }

    public int compareToUsingFlows(RowSegment<E> other) {
        if (this.isFlowingLeft()) {
            int result = this.compareRights(other);
            if (result == 0) {
                result = this.compareLefts(other);
            }
            return result;
        }
        int result = this.compareLefts(other);
        if (result == 0) {
            result = this.compareRights(other);
        }
        return result;
    }

    public boolean overlaps(RowSegment<E> other) {
        if (this.getLeftCol() > other.getRightCol()) {
            return false;
        }
        if (this.getRightCol() < other.getLeftCol()) {
            return false;
        }
        if (this.getLeftCol() == other.getRightCol()) {
            return !this.isLeftTerminal() || !other.isRightTerminal();
        }
        if (this.getRightCol() == other.getLeftCol()) {
            return !this.isRightTerminal() || !other.isLeftTerminal();
        }
        return true;
    }

    public int compareLefts(RowSegment<E> other) {
        ColumnOrientation otherLeftColOrientation;
        int result = this.getRow() - other.getRow();
        if (result != 0) {
            return result;
        }
        ColumnOrientation myLeftColOrientation = this.getOrientationForLeftColumn();
        if (myLeftColOrientation != (otherLeftColOrientation = other.getOrientationForLeftColumn())) {
            return myLeftColOrientation.compareTo(otherLeftColOrientation);
        }
        ColumnSegment<E> myLeftColSegment = this.getLeftColSegment();
        ColumnSegment<E> otherLeftColSegment = other.getLeftColSegment();
        if (myLeftColOrientation == ColumnOrientation.UP) {
            return -myLeftColSegment.compareTops(otherLeftColSegment);
        }
        return myLeftColSegment.compareBottoms(otherLeftColSegment);
    }

    public int compareRights(RowSegment<E> other) {
        ColumnOrientation otherRightColOrientation;
        int result = this.getRow() - other.getRow();
        if (result != 0) {
            return result;
        }
        ColumnOrientation myRightColOrientation = this.getOrientationForRightColumn();
        if (myRightColOrientation != (otherRightColOrientation = other.getOrientationForRightColumn())) {
            return myRightColOrientation.compareTo(otherRightColOrientation);
        }
        ColumnSegment<E> myRightColSegment = this.getRightColSegment();
        ColumnSegment<E> otherRightColSegment = other.getRightColSegment();
        if (myRightColOrientation == ColumnOrientation.UP) {
            return myRightColSegment.compareTops(otherRightColSegment);
        }
        return -myRightColSegment.compareBottoms(otherRightColSegment);
    }

    @Override
    public ColumnSegment<E> nextSegment() {
        return this.next;
    }

    @Override
    public ColumnSegment<E> previousSegment() {
        return this.previous;
    }

    private ColumnOrientation getOrientationForLeftColumn() {
        ColumnSegment<E> leftSegment = this.getLeftColSegment();
        int leftColOtherRow = this.isFlowingLeft() ? leftSegment.getEndRow() : leftSegment.getStartRow();
        return leftColOtherRow < this.getRow() ? ColumnOrientation.UP : ColumnOrientation.DOWN;
    }

    private ColumnOrientation getOrientationForRightColumn() {
        ColumnSegment<E> rightSegment = this.getRightColSegment();
        int rightColOtherRow = this.isFlowingLeft() ? rightSegment.getStartRow() : rightSegment.getEndRow();
        return rightColOtherRow < this.getRow() ? ColumnOrientation.UP : ColumnOrientation.DOWN;
    }

    private ColumnSegment<E> getLeftColSegment() {
        return this.isFlowingLeft() ? this.next : this.previous;
    }

    private ColumnSegment<E> getRightColSegment() {
        return this.isFlowingLeft() ? this.previous : this.next;
    }

    boolean isFlowingLeft() {
        return this.getStartCol() > this.getEndCol();
    }

    private boolean isLeftTerminal() {
        ColumnSegment<E> left = this.getLeftColSegment();
        return left.isStartSegment() || left.isEndSegment();
    }

    private boolean isRightTerminal() {
        ColumnSegment<E> right = this.getRightColSegment();
        return right.isStartSegment() || right.isEndSegment();
    }

    public ColumnSegment<E> last() {
        return this.next.last();
    }

    static enum ColumnOrientation {
        UP,
        DOWN;

    }
}

