/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.plugin;

import ghidra.feature.fid.db.FidDB;
import ghidra.feature.fid.db.FidFile;
import ghidra.feature.fid.db.LibraryRecord;
import ghidra.feature.fid.service.FidPopulateResult;
import ghidra.feature.fid.service.FidPopulateResultReporter;
import ghidra.feature.fid.service.FidService;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class IngestTask
extends Task {
    private FidFile fidFile;
    private LibraryRecord libraryRecord;
    protected DomainFolder folder;
    protected String libraryFamilyName;
    protected String libraryVersion;
    protected String libraryVariant;
    private LanguageID languageId;
    private File commonSymbolsFile;
    private FidService fidService;
    private FidPopulateResultReporter reporter;

    public IngestTask(String title, FidFile fidFile, LibraryRecord libraryRecord, DomainFolder folder, String libraryFamilyName, String libraryVersion, String libraryVariant, String languageId, File commonSymbolsFile, FidService fidService, FidPopulateResultReporter reporter) {
        super(title, true, false, false, false);
        this.fidFile = fidFile;
        this.libraryRecord = libraryRecord;
        this.folder = folder;
        this.libraryFamilyName = libraryFamilyName;
        this.libraryVersion = libraryVersion;
        this.libraryVariant = libraryVariant;
        this.commonSymbolsFile = commonSymbolsFile;
        this.fidService = fidService;
        this.reporter = reporter;
        this.languageId = new LanguageID(languageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        FidDB fidDb = null;
        try {
            fidDb = this.fidFile.getFidDB(true);
        }
        catch (VersionException e) {
            Msg.showError((Object)((Object)this), null, (String)"Failed to open FidDb", (Object)("Failed to open incompatible FidDb (may need to regenerate with this version of Ghidra): " + this.fidFile.getPath()));
            return;
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"Failed to open FidDb", (Object)("Failed to open FidDb: " + this.fidFile.getPath()), (Throwable)e);
            return;
        }
        try {
            List<String> commonSymbols = this.parseSymbols(monitor);
            ArrayList<DomainFile> programs = new ArrayList<DomainFile>();
            monitor.setMessage("Finding domain files...");
            monitor.setIndeterminate(true);
            this.findPrograms(programs, this.folder, monitor);
            monitor.setIndeterminate(false);
            monitor.setMessage("Populating library...");
            FidPopulateResult result = this.fidService.createNewLibraryFromPrograms(fidDb, this.libraryFamilyName, this.libraryVersion, this.libraryVariant, programs, null, this.languageId, this.libraryRecord == null ? null : Arrays.asList(this.libraryRecord), commonSymbols, monitor);
            this.reporter.report(result);
            fidDb.saveDatabase("Saving", monitor);
        }
        catch (CancelledException commonSymbols) {
        }
        catch (MemoryAccessException e) {
            Msg.showError((Object)((Object)this), null, (String)"Unexpected memory access exception", (Object)"Please notify the Ghidra team:", (Throwable)e);
        }
        catch (VersionException e) {
            Msg.showError((Object)((Object)this), null, (String)"Version Exception", (Object)("One of the programs in your domain folder cannot be upgraded: " + e.getMessage()));
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"FidDb IOException", (Object)"Please notify the Ghidra team:", (Throwable)e);
        }
        finally {
            fidDb.close();
        }
    }

    private List<String> parseSymbols(TaskMonitor monitor) throws IOException, CancelledException {
        if (this.commonSymbolsFile == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new FileReader(this.commonSymbolsFile));
        LinkedList<String> res = new LinkedList<String>();
        String line = reader.readLine();
        while (line != null) {
            monitor.checkCancelled();
            if (line.length() != 0) {
                res.add(line);
            }
            line = reader.readLine();
        }
        reader.close();
        return res;
    }

    protected void findPrograms(ArrayList<DomainFile> programs, DomainFolder myFolder, TaskMonitor monitor) throws CancelledException {
        DomainFolder[] folders;
        DomainFile[] files;
        if (myFolder == null) {
            return;
        }
        for (DomainFile domainFile : files = myFolder.getFiles()) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            if (!domainFile.getContentType().equals("Program")) continue;
            programs.add(domainFile);
        }
        for (DomainFolder domainFolder : folders = myFolder.getFolders()) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            this.findPrograms(programs, domainFolder, monitor);
        }
    }
}

