/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.wizard.project;

import docking.wizard.WizardModel;
import docking.wizard.WizardStep;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.main.wizard.project.ProjectWizardData;
import ghidra.framework.main.wizard.project.RepositoryPanel;
import ghidra.framework.model.ServerInfo;
import ghidra.util.HelpLocation;
import ghidra.util.NamingUtilities;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;

public class RepositoryStep
extends WizardStep<ProjectWizardData> {
    private RepositoryPanel panel;
    private RepositoryServerAdapter server;
    private String[] repositoryNames;

    protected RepositoryStep(WizardModel<ProjectWizardData> model) {
        super(model, "", new HelpLocation("FrontEndPlugin", "SelectRepository"));
    }

    public void initialize(ProjectWizardData data) {
        ServerInfo serverInfo = data.getServerInfo();
        this.setTitle("Specify Repository Name from server: " + serverInfo.getServerName());
        this.server = data.getServer();
        this.repositoryNames = this.getRepositoryNames();
        if (this.panel == null) {
            boolean readOnly = this.isServerReadOnly();
            this.panel = new RepositoryPanel(() -> this.notifyStatusChanged(), this.repositoryNames, readOnly);
        }
    }

    private boolean isServerReadOnly() {
        try {
            return this.server.isReadOnly();
        }
        catch (IOException e) {
            return true;
        }
    }

    private String[] getRepositoryNames() {
        try {
            return this.server.getRepositoryNames();
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    public boolean isValid() {
        String repositoryName = this.panel.getRepositoryName();
        if (this.panel.isCreateRepositorySelected()) {
            if (repositoryName.length() == 0) {
                return false;
            }
            if (!NamingUtilities.isValidProjectName((String)repositoryName)) {
                this.setStatusMessage("Invalid project repository name");
                return false;
            }
            if (List.of(this.repositoryNames).contains(repositoryName)) {
                this.setStatusMessage("Repository " + repositoryName + " already exists");
                return false;
            }
        } else if (repositoryName == null) {
            this.setStatusMessage("Please select a repository");
            return false;
        }
        return true;
    }

    public void populateData(ProjectWizardData data) {
        data.setRepositoryName(this.panel.getRepositoryName());
        data.setIsNewRepository(this.panel.isCreateRepositorySelected());
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public boolean apply(ProjectWizardData data) {
        return true;
    }

    public boolean canFinish(ProjectWizardData data) {
        return data.getRepositoryName() != null;
    }

    public boolean isApplicable(ProjectWizardData data) {
        return data.isSharedProject();
    }
}

