---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Oculus access token'
---

## Description

The response body contains content that matches the pattern of an Oculus access token was identified. User tokens are needed any time your app calls an API to read, modify or write a specific person's Oculus data on their behalf. A malicious actor with access to this token can call the Oculus API on behalf of a specific user of the service.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To rotate an Oculus access token:

- Sign in to your Oculus developer account at <https://developer.oculus.com/>
- Select "Development" in the left-hand side menu, and then select "API"
- Under "User Token" select "Generate Token"

For more information, please see [Meta's documentation on protecting access tokens](https://developers.meta.com/horizon/resources/publish-sec-details#protecting-credentials-and-access-tokens)

## Details

| ID      | Aggregated | CWE | Type | Risk |
|:--------|:-----------|:----|:-----|:-----|
| 798.162 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
