/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.declarations;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.gradle.internal.classpath.InstrumentedClosuresHelper;
import org.gradle.internal.classpath.InstrumentedGroovyCallsHelper;
import org.gradle.internal.classpath.InstrumentedGroovyCallsTracker;
import org.gradle.internal.classpath.intercept.CallInterceptorResolver;
import org.gradle.internal.instrumentation.api.annotations.CallableKind;
import org.gradle.internal.instrumentation.api.annotations.InterceptJvmCalls;
import org.gradle.internal.instrumentation.api.annotations.ParameterKind;
import org.gradle.internal.instrumentation.api.annotations.SpecificJvmCallInterceptors;
import org.gradle.internal.instrumentation.api.groovybytecode.CallInterceptor;
import org.gradle.internal.instrumentation.api.groovybytecode.InterceptScope;
import org.gradle.internal.instrumentation.api.groovybytecode.Invocation;
import org.gradle.internal.instrumentation.api.groovybytecode.InvocationImpl;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorFilter;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@SpecificJvmCallInterceptors(generatedClassName="org.gradle.internal.classpath.generated.InterceptorDeclaration_ConfigCacheJvmBytecode")
public class GroovyDynamicDispatchInterceptors {
    @InterceptJvmCalls
    @CallableKind.StaticMethod(ofClass=ScriptBytecodeAdapter.class)
    public static void intercept_setGroovyObjectProperty(Object messageArgument, Class<?> senderClass, GroovyObject receiver, String messageName, @ParameterKind.CallerClassName String consumer, @ParameterKind.InjectVisitorContext BytecodeInterceptorFilter interceptorFilter) throws Throwable {
        if (!CallInterceptorResolver.ClosureCallInterceptorResolver.of(interceptorFilter).isAwareOfCallSiteName(messageName)) {
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)messageArgument, senderClass, (GroovyObject)receiver, (String)messageName);
            return;
        }
        InstrumentedClosuresHelper.INSTANCE.hitInstrumentedDynamicCall();
        InstrumentedGroovyCallsHelper.withEntryPoint(consumer, messageName, InstrumentedGroovyCallsTracker.CallKind.SET_PROPERTY, () -> {
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)messageArgument, (Class)senderClass, (GroovyObject)receiver, (String)messageName);
            return null;
        });
    }

    @InterceptJvmCalls
    @CallableKind.StaticMethod(ofClass=ScriptBytecodeAdapter.class)
    public static void intercept_setProperty(Object messageArgument, Class<?> senderClass, Object receiver, String messageName, @ParameterKind.CallerClassName String consumer, @ParameterKind.InjectVisitorContext BytecodeInterceptorFilter interceptorFilter) throws Throwable {
        CallInterceptorResolver interceptorResolver = CallInterceptorResolver.ClosureCallInterceptorResolver.of(interceptorFilter);
        CallInterceptor interceptor = interceptorResolver.resolveCallInterceptor(InterceptScope.writesOfPropertiesNamed((String)messageName));
        if (interceptor != null) {
            Object[] args = new Object[]{messageArgument};
            interceptor.intercept((Invocation)new InvocationImpl(receiver, args, () -> {
                GroovyDynamicDispatchInterceptors.callInstrumentedSetProperty(messageArgument, senderClass, receiver, messageName, consumer, interceptorFilter);
                return null;
            }), consumer);
        } else {
            GroovyDynamicDispatchInterceptors.callInstrumentedSetProperty(messageArgument, senderClass, receiver, messageName, consumer, interceptorFilter);
        }
    }

    private static void callInstrumentedSetProperty(Object messageArgument, Class<?> senderClass, Object receiver, String messageName, String consumer, BytecodeInterceptorFilter interceptorFilter) throws Throwable {
        if (!CallInterceptorResolver.ClosureCallInterceptorResolver.of(interceptorFilter).isAwareOfCallSiteName(messageName)) {
            ScriptBytecodeAdapter.setProperty((Object)messageArgument, senderClass, (Object)receiver, (String)messageName);
            return;
        }
        InstrumentedClosuresHelper.INSTANCE.hitInstrumentedDynamicCall();
        InstrumentedGroovyCallsHelper.withEntryPoint(consumer, messageName, InstrumentedGroovyCallsTracker.CallKind.SET_PROPERTY, () -> {
            ScriptBytecodeAdapter.setProperty((Object)messageArgument, (Class)senderClass, (Object)receiver, (String)messageName);
            return null;
        });
    }

    @InterceptJvmCalls
    @CallableKind.StaticMethod(ofClass=ScriptBytecodeAdapter.class)
    public static Closure<?> intercept_getMethodPointer(final Object owner, @Nullable String methodName, final @ParameterKind.CallerClassName String consumer, @ParameterKind.InjectVisitorContext BytecodeInterceptorFilter interceptorFilter) {
        InterceptScope scope;
        final Closure originalPointer = ScriptBytecodeAdapter.getMethodPointer((Object)owner, (String)methodName);
        if (methodName == null) {
            return originalPointer;
        }
        CallInterceptorResolver resolver = CallInterceptorResolver.ClosureCallInterceptorResolver.of(interceptorFilter);
        final CallInterceptor interceptor = resolver.resolveCallInterceptor(scope = GroovyDynamicDispatchInterceptors.isConstructorMethodRef(owner, methodName) ? InterceptScope.constructorsOf((Class)((Class)owner)) : InterceptScope.methodsNamed((String)methodName));
        if (interceptor == null) {
            return originalPointer;
        }
        class MethodRefInterceptorClosure
        extends Closure<Object> {
            public MethodRefInterceptorClosure() {
                super(object);
            }

            public @Nullable Object doCall(Object ... arguments) throws Throwable {
                Object owner2 = this.getOwner();
                return interceptor.intercept((Invocation)new InvocationImpl(owner2, arguments, () -> {
                    if (this.canBeUnboundInstanceMethodInvocation(owner2, arguments)) {
                        Object maybeInstanceReceiver = arguments[0];
                        Object[] boundCallArguments = this.subArray(arguments, 1);
                        return interceptor.intercept((Invocation)new InvocationImpl(maybeInstanceReceiver, boundCallArguments, () -> InvokerHelper.invokeClosure((Object)originalPointer, (Object)arguments)), consumer);
                    }
                    return InvokerHelper.invokeClosure((Object)originalPointer, (Object)arguments);
                }), consumer);
            }

            private boolean canBeUnboundInstanceMethodInvocation(Object owner2, Object[] arguments) {
                return arguments.length > 0 && owner2 instanceof Class && ((Class)owner2).isInstance(arguments[0]);
            }

            private Object[] subArray(Object[] array, int pos) {
                Object[] subArray = new Object[array.length - pos];
                System.arraycopy(array, pos, subArray, 0, subArray.length);
                return subArray;
            }
        }
        return new MethodRefInterceptorClosure();
    }

    private static boolean isConstructorMethodRef(Object owner, String methodName) {
        return "new".equals(methodName) && owner instanceof Class;
    }
}

