/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.SendBuilder;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddRaftVoterRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterShareGroupOffsetsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.AssignReplicasToDirsRequest;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.ConsumerGroupDescribeRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ControllerRegistrationRequest;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateDelegationTokenRequest;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteShareGroupOffsetsRequest;
import org.apache.kafka.common.requests.DeleteShareGroupStateRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeClientQuotasRequest;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeDelegationTokenRequest;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeProducersRequest;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.DescribeShareGroupOffsetsRequest;
import org.apache.kafka.common.requests.DescribeTopicPartitionsRequest;
import org.apache.kafka.common.requests.DescribeTransactionsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.ExpireDelegationTokenRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchSnapshotRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.GetTelemetrySubscriptionsRequest;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitializeShareGroupStateRequest;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.ListConfigResourcesRequest;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.ListTransactionsRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetDeleteRequest;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.PushTelemetryRequest;
import org.apache.kafka.common.requests.ReadShareGroupStateRequest;
import org.apache.kafka.common.requests.ReadShareGroupStateSummaryRequest;
import org.apache.kafka.common.requests.RemoveRaftVoterRequest;
import org.apache.kafka.common.requests.RenewDelegationTokenRequest;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.requests.SaslAuthenticateRequest;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.ShareAcknowledgeRequest;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.requests.ShareGroupDescribeRequest;
import org.apache.kafka.common.requests.ShareGroupHeartbeatRequest;
import org.apache.kafka.common.requests.StreamsGroupDescribeRequest;
import org.apache.kafka.common.requests.StreamsGroupHeartbeatRequest;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateRaftVoterRequest;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.requests.WriteShareGroupStateRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;

public abstract class AbstractRequest
implements AbstractRequestResponse {
    private final short version;
    private final ApiKeys apiKey;

    public AbstractRequest(ApiKeys apiKey, short version) {
        if (!apiKey.isVersionSupported(version)) {
            throw new UnsupportedVersionException("The " + String.valueOf((Object)apiKey) + " protocol does not support version " + version);
        }
        this.version = version;
        this.apiKey = apiKey;
    }

    public short version() {
        return this.version;
    }

    public ApiKeys apiKey() {
        return this.apiKey;
    }

    public final Send toSend(RequestHeader header) {
        return SendBuilder.buildRequestSend(header, this.data());
    }

    public final ByteBuffer serializeWithHeader(RequestHeader header) {
        if (header.apiKey() != this.apiKey) {
            throw new IllegalArgumentException("Could not build request " + String.valueOf((Object)this.apiKey) + " with header api key " + String.valueOf((Object)header.apiKey()));
        }
        if (header.apiVersion() != this.version) {
            throw new IllegalArgumentException("Could not build request version " + this.version + " with header version " + header.apiVersion());
        }
        return RequestUtils.serialize(header.data(), header.headerVersion(), this.data(), this.version);
    }

    public final ByteBufferAccessor serialize() {
        return MessageUtil.toByteBufferAccessor(this.data(), this.version);
    }

    final int sizeInBytes() {
        return this.data().size(new ObjectSerializationCache(), this.version);
    }

    public String toString(boolean verbose) {
        return this.data().toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public AbstractResponse getErrorResponse(Throwable e) {
        return this.getErrorResponse(0, e);
    }

    public abstract AbstractResponse getErrorResponse(int var1, Throwable var2);

    public Map<Errors, Integer> errorCounts(Throwable e) {
        AbstractResponse response = this.getErrorResponse(0, e);
        if (response == null) {
            throw new IllegalStateException("Error counts could not be obtained for request " + String.valueOf(this));
        }
        return response.errorCounts();
    }

    public static RequestAndSize parseRequest(ApiKeys apiKey, short apiVersion, Readable readable) {
        int bufferSize = readable.remaining();
        return new RequestAndSize(AbstractRequest.doParseRequest(apiKey, apiVersion, readable), bufferSize);
    }

    private static AbstractRequest doParseRequest(ApiKeys apiKey, short apiVersion, Readable readable) {
        switch (apiKey) {
            case PRODUCE: {
                return ProduceRequest.parse(readable, apiVersion);
            }
            case FETCH: {
                return FetchRequest.parse(readable, apiVersion);
            }
            case LIST_OFFSETS: {
                return ListOffsetsRequest.parse(readable, apiVersion);
            }
            case METADATA: {
                return MetadataRequest.parse(readable, apiVersion);
            }
            case OFFSET_COMMIT: {
                return OffsetCommitRequest.parse(readable, apiVersion);
            }
            case OFFSET_FETCH: {
                return OffsetFetchRequest.parse(readable, apiVersion);
            }
            case FIND_COORDINATOR: {
                return FindCoordinatorRequest.parse(readable, apiVersion);
            }
            case JOIN_GROUP: {
                return JoinGroupRequest.parse(readable, apiVersion);
            }
            case HEARTBEAT: {
                return HeartbeatRequest.parse(readable, apiVersion);
            }
            case LEAVE_GROUP: {
                return LeaveGroupRequest.parse(readable, apiVersion);
            }
            case SYNC_GROUP: {
                return SyncGroupRequest.parse(readable, apiVersion);
            }
            case DESCRIBE_GROUPS: {
                return DescribeGroupsRequest.parse(readable, apiVersion);
            }
            case LIST_GROUPS: {
                return ListGroupsRequest.parse(readable, apiVersion);
            }
            case SASL_HANDSHAKE: {
                return SaslHandshakeRequest.parse(readable, apiVersion);
            }
            case API_VERSIONS: {
                return ApiVersionsRequest.parse(readable, apiVersion);
            }
            case CREATE_TOPICS: {
                return CreateTopicsRequest.parse(readable, apiVersion);
            }
            case DELETE_TOPICS: {
                return DeleteTopicsRequest.parse(readable, apiVersion);
            }
            case DELETE_RECORDS: {
                return DeleteRecordsRequest.parse(readable, apiVersion);
            }
            case INIT_PRODUCER_ID: {
                return InitProducerIdRequest.parse(readable, apiVersion);
            }
            case OFFSET_FOR_LEADER_EPOCH: {
                return OffsetsForLeaderEpochRequest.parse(readable, apiVersion);
            }
            case ADD_PARTITIONS_TO_TXN: {
                return AddPartitionsToTxnRequest.parse(readable, apiVersion);
            }
            case ADD_OFFSETS_TO_TXN: {
                return AddOffsetsToTxnRequest.parse(readable, apiVersion);
            }
            case END_TXN: {
                return EndTxnRequest.parse(readable, apiVersion);
            }
            case WRITE_TXN_MARKERS: {
                return WriteTxnMarkersRequest.parse(readable, apiVersion);
            }
            case TXN_OFFSET_COMMIT: {
                return TxnOffsetCommitRequest.parse(readable, apiVersion);
            }
            case DESCRIBE_ACLS: {
                return DescribeAclsRequest.parse(readable, apiVersion);
            }
            case CREATE_ACLS: {
                return CreateAclsRequest.parse(readable, apiVersion);
            }
            case DELETE_ACLS: {
                return DeleteAclsRequest.parse(readable, apiVersion);
            }
            case DESCRIBE_CONFIGS: {
                return DescribeConfigsRequest.parse(readable, apiVersion);
            }
            case ALTER_CONFIGS: {
                return AlterConfigsRequest.parse(readable, apiVersion);
            }
            case ALTER_REPLICA_LOG_DIRS: {
                return AlterReplicaLogDirsRequest.parse(readable, apiVersion);
            }
            case DESCRIBE_LOG_DIRS: {
                return DescribeLogDirsRequest.parse(readable, apiVersion);
            }
            case SASL_AUTHENTICATE: {
                return SaslAuthenticateRequest.parse(readable, apiVersion);
            }
            case CREATE_PARTITIONS: {
                return CreatePartitionsRequest.parse(readable, apiVersion);
            }
            case CREATE_DELEGATION_TOKEN: {
                return CreateDelegationTokenRequest.parse(readable, apiVersion);
            }
            case RENEW_DELEGATION_TOKEN: {
                return RenewDelegationTokenRequest.parse(readable, apiVersion);
            }
            case EXPIRE_DELEGATION_TOKEN: {
                return ExpireDelegationTokenRequest.parse(readable, apiVersion);
            }
            case DESCRIBE_DELEGATION_TOKEN: {
                return DescribeDelegationTokenRequest.parse(readable, apiVersion);
            }
            case DELETE_GROUPS: {
                return DeleteGroupsRequest.parse(readable, apiVersion);
            }
            case ELECT_LEADERS: {
                return ElectLeadersRequest.parse(readable, apiVersion);
            }
            case INCREMENTAL_ALTER_CONFIGS: {
                return IncrementalAlterConfigsRequest.parse(readable, apiVersion);
            }
            case ALTER_PARTITION_REASSIGNMENTS: {
                return AlterPartitionReassignmentsRequest.parse(readable, apiVersion);
            }
            case LIST_PARTITION_REASSIGNMENTS: {
                return ListPartitionReassignmentsRequest.parse(readable, apiVersion);
            }
            case OFFSET_DELETE: {
                return OffsetDeleteRequest.parse(readable, apiVersion);
            }
            case DESCRIBE_CLIENT_QUOTAS: {
                return DescribeClientQuotasRequest.parse(readable, apiVersion);
            }
            case ALTER_CLIENT_QUOTAS: {
                return AlterClientQuotasRequest.parse(readable, apiVersion);
            }
            case DESCRIBE_USER_SCRAM_CREDENTIALS: {
                return DescribeUserScramCredentialsRequest.parse(readable, apiVersion);
            }
            case ALTER_USER_SCRAM_CREDENTIALS: {
                return AlterUserScramCredentialsRequest.parse(readable, apiVersion);
            }
            case VOTE: {
                return VoteRequest.parse(readable, apiVersion);
            }
            case BEGIN_QUORUM_EPOCH: {
                return BeginQuorumEpochRequest.parse(readable, apiVersion);
            }
            case END_QUORUM_EPOCH: {
                return EndQuorumEpochRequest.parse(readable, apiVersion);
            }
            case DESCRIBE_QUORUM: {
                return DescribeQuorumRequest.parse(readable, apiVersion);
            }
            case ALTER_PARTITION: {
                return AlterPartitionRequest.parse(readable, apiVersion);
            }
            case UPDATE_FEATURES: {
                return UpdateFeaturesRequest.parse(readable, apiVersion);
            }
            case ENVELOPE: {
                return EnvelopeRequest.parse(readable, apiVersion);
            }
            case FETCH_SNAPSHOT: {
                return FetchSnapshotRequest.parse(readable, apiVersion);
            }
            case DESCRIBE_CLUSTER: {
                return DescribeClusterRequest.parse(readable, apiVersion);
            }
            case DESCRIBE_PRODUCERS: {
                return DescribeProducersRequest.parse(readable, apiVersion);
            }
            case BROKER_REGISTRATION: {
                return BrokerRegistrationRequest.parse(readable, apiVersion);
            }
            case BROKER_HEARTBEAT: {
                return BrokerHeartbeatRequest.parse(readable, apiVersion);
            }
            case UNREGISTER_BROKER: {
                return UnregisterBrokerRequest.parse(readable, apiVersion);
            }
            case DESCRIBE_TRANSACTIONS: {
                return DescribeTransactionsRequest.parse(readable, apiVersion);
            }
            case LIST_TRANSACTIONS: {
                return ListTransactionsRequest.parse(readable, apiVersion);
            }
            case ALLOCATE_PRODUCER_IDS: {
                return AllocateProducerIdsRequest.parse(readable, apiVersion);
            }
            case CONSUMER_GROUP_HEARTBEAT: {
                return ConsumerGroupHeartbeatRequest.parse(readable, apiVersion);
            }
            case CONSUMER_GROUP_DESCRIBE: {
                return ConsumerGroupDescribeRequest.parse(readable, apiVersion);
            }
            case CONTROLLER_REGISTRATION: {
                return ControllerRegistrationRequest.parse(readable, apiVersion);
            }
            case GET_TELEMETRY_SUBSCRIPTIONS: {
                return GetTelemetrySubscriptionsRequest.parse(readable, apiVersion);
            }
            case PUSH_TELEMETRY: {
                return PushTelemetryRequest.parse(readable, apiVersion);
            }
            case ASSIGN_REPLICAS_TO_DIRS: {
                return AssignReplicasToDirsRequest.parse(readable, apiVersion);
            }
            case LIST_CONFIG_RESOURCES: {
                return ListConfigResourcesRequest.parse(readable, apiVersion);
            }
            case DESCRIBE_TOPIC_PARTITIONS: {
                return DescribeTopicPartitionsRequest.parse(readable, apiVersion);
            }
            case SHARE_GROUP_HEARTBEAT: {
                return ShareGroupHeartbeatRequest.parse(readable, apiVersion);
            }
            case SHARE_GROUP_DESCRIBE: {
                return ShareGroupDescribeRequest.parse(readable, apiVersion);
            }
            case SHARE_FETCH: {
                return ShareFetchRequest.parse(readable, apiVersion);
            }
            case SHARE_ACKNOWLEDGE: {
                return ShareAcknowledgeRequest.parse(readable, apiVersion);
            }
            case ADD_RAFT_VOTER: {
                return AddRaftVoterRequest.parse(readable, apiVersion);
            }
            case REMOVE_RAFT_VOTER: {
                return RemoveRaftVoterRequest.parse(readable, apiVersion);
            }
            case UPDATE_RAFT_VOTER: {
                return UpdateRaftVoterRequest.parse(readable, apiVersion);
            }
            case INITIALIZE_SHARE_GROUP_STATE: {
                return InitializeShareGroupStateRequest.parse(readable, apiVersion);
            }
            case READ_SHARE_GROUP_STATE: {
                return ReadShareGroupStateRequest.parse(readable, apiVersion);
            }
            case WRITE_SHARE_GROUP_STATE: {
                return WriteShareGroupStateRequest.parse(readable, apiVersion);
            }
            case DELETE_SHARE_GROUP_STATE: {
                return DeleteShareGroupStateRequest.parse(readable, apiVersion);
            }
            case READ_SHARE_GROUP_STATE_SUMMARY: {
                return ReadShareGroupStateSummaryRequest.parse(readable, apiVersion);
            }
            case STREAMS_GROUP_HEARTBEAT: {
                return StreamsGroupHeartbeatRequest.parse(readable, apiVersion);
            }
            case STREAMS_GROUP_DESCRIBE: {
                return StreamsGroupDescribeRequest.parse(readable, apiVersion);
            }
            case DESCRIBE_SHARE_GROUP_OFFSETS: {
                return DescribeShareGroupOffsetsRequest.parse(readable, apiVersion);
            }
            case ALTER_SHARE_GROUP_OFFSETS: {
                return AlterShareGroupOffsetsRequest.parse(readable, apiVersion);
            }
            case DELETE_SHARE_GROUP_OFFSETS: {
                return DeleteShareGroupOffsetsRequest.parse(readable, apiVersion);
            }
        }
        throw new AssertionError((Object)String.format("ApiKey %s is not currently handled in `parseRequest`, the code should be updated to do so.", new Object[]{apiKey}));
    }

    public static abstract class Builder<T extends AbstractRequest> {
        private final ApiKeys apiKey;
        private final short oldestAllowedVersion;
        private final short latestAllowedVersion;

        public Builder(ApiKeys apiKey, boolean enableUnstableLastVersion) {
            this(apiKey, apiKey.oldestVersion(), apiKey.latestVersion(enableUnstableLastVersion));
        }

        public Builder(ApiKeys apiKey) {
            this(apiKey, false);
        }

        public Builder(ApiKeys apiKey, short allowedVersion) {
            this(apiKey, allowedVersion, allowedVersion);
        }

        public Builder(ApiKeys apiKey, short oldestAllowedVersion, short latestAllowedVersion) {
            this.apiKey = apiKey;
            this.oldestAllowedVersion = oldestAllowedVersion;
            this.latestAllowedVersion = latestAllowedVersion;
        }

        public ApiKeys apiKey() {
            return this.apiKey;
        }

        public short oldestAllowedVersion() {
            return this.oldestAllowedVersion;
        }

        public short latestAllowedVersion() {
            return this.latestAllowedVersion;
        }

        public T build() {
            return this.build(this.latestAllowedVersion());
        }

        public abstract T build(short var1);
    }
}

