/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.server.common.MetadataVersion;

public final class FeaturesDelta {
    private final FeaturesImage image;
    private final Map<String, Optional<Short>> changes = new HashMap<String, Optional<Short>>();
    private MetadataVersion metadataVersionChange = null;

    public FeaturesDelta(FeaturesImage image) {
        this.image = image;
    }

    public Map<String, Optional<Short>> changes() {
        return this.changes;
    }

    public Optional<MetadataVersion> metadataVersionChange() {
        return Optional.ofNullable(this.metadataVersionChange);
    }

    public void finishSnapshot() {
        for (String featureName : this.image.finalizedVersions().keySet()) {
            if (this.changes.containsKey(featureName)) continue;
            this.changes.put(featureName, Optional.empty());
        }
    }

    public void replay(FeatureLevelRecord record) {
        if (record.name().equals("metadata.version")) {
            try {
                this.metadataVersionChange = MetadataVersion.fromFeatureLevel((short)record.featureLevel());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unsupported metadata version - if you are currently upgrading your cluster, please ensure the metadata version is set to " + String.valueOf(MetadataVersion.MINIMUM_VERSION) + " (or higher) before updating the software version. The metadata version can be updated via the `kafka-features` command-line tool.", e);
            }
        } else if (!record.name().equals("kraft.version")) {
            if (record.featureLevel() == 0) {
                this.changes.put(record.name(), Optional.empty());
            } else {
                this.changes.put(record.name(), Optional.of(record.featureLevel()));
            }
        }
    }

    public FeaturesImage apply() {
        Optional change;
        String name;
        HashMap<String, Short> newFinalizedVersions = new HashMap<String, Short>(this.image.finalizedVersions().size());
        for (Map.Entry<String, Short> entry : this.image.finalizedVersions().entrySet()) {
            name = entry.getKey();
            change = this.changes.get(name);
            if (change == null) {
                newFinalizedVersions.put(name, entry.getValue());
                continue;
            }
            if (!change.isPresent()) continue;
            newFinalizedVersions.put(name, (Short)change.get());
        }
        for (Map.Entry<String, Object> entry : this.changes.entrySet()) {
            name = entry.getKey();
            change = (Optional)entry.getValue();
            if (newFinalizedVersions.containsKey(name) || !change.isPresent()) continue;
            newFinalizedVersions.put(name, (Short)change.get());
        }
        Optional<MetadataVersion> metadataVersion = this.metadataVersionChange == null ? this.image.metadataVersion() : Optional.of(this.metadataVersionChange);
        return new FeaturesImage(newFinalizedVersions, metadataVersion);
    }

    public String toString() {
        return "FeaturesDelta(changes=" + String.valueOf(this.changes) + ", metadataVersionChange=" + String.valueOf(this.metadataVersionChange) + ")";
    }
}

