/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.json.JsonValueFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.spi.TypeConfiguration;

public class HANAJsonValueFunction
extends JsonValueFunction {
    public HANAJsonValueFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, false);
    }

    @Override
    protected void render(SqlAppender sqlAppender, JsonValueFunction.JsonValueArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        boolean encodedBoolean;
        boolean bl = encodedBoolean = arguments.returningType() != null && HANAJsonValueFunction.isEncodedBoolean(arguments.returningType().getJdbcMapping());
        if (encodedBoolean) {
            sqlAppender.append("case ");
        }
        super.render(sqlAppender, arguments, returnType, walker);
        if (encodedBoolean) {
            JdbcMapping type = arguments.returningType().getJdbcMapping();
            JdbcLiteralFormatter jdbcLiteralFormatter = type.getJdbcLiteralFormatter();
            SessionFactoryImplementor sessionFactory = walker.getSessionFactory();
            Dialect dialect = sessionFactory.getJdbcServices().getDialect();
            WrapperOptions wrapperOptions = sessionFactory.getWrapperOptions();
            Object trueValue = type.convertToRelationalValue(true);
            Object falseValue = type.convertToRelationalValue(false);
            sqlAppender.append(" when 'true' then ");
            jdbcLiteralFormatter.appendJdbcLiteral(sqlAppender, trueValue, dialect, wrapperOptions);
            sqlAppender.append(" when 'false' then ");
            jdbcLiteralFormatter.appendJdbcLiteral(sqlAppender, falseValue, dialect, wrapperOptions);
            sqlAppender.append(" end");
        }
    }

    public static String jsonValueReturningType(SqlTypedMapping column) {
        String columnDefinition = column.getColumnDefinition();
        assert (columnDefinition != null);
        return HANAJsonValueFunction.jsonValueReturningType(columnDefinition);
    }

    public static String jsonValueReturningType(String columnDefinition) {
        String baseName;
        int parenthesisIndex = columnDefinition.indexOf(40);
        return switch (baseName = parenthesisIndex == -1 ? columnDefinition : columnDefinition.substring(0, parenthesisIndex)) {
            case "real", "float", "double", "decimal" -> "decimal";
            case "tinyint", "smallint" -> "integer";
            case "clob" -> "varchar(5000)";
            case "nclob" -> "nvarchar(5000)";
            default -> columnDefinition;
        };
    }

    @Override
    protected void renderReturningClause(SqlAppender sqlAppender, JsonValueFunction.JsonValueArguments arguments, SqlAstTranslator<?> walker) {
        if (arguments.returningType() != null && !HANAJsonValueFunction.isEncodedBoolean(arguments.returningType().getJdbcMapping())) {
            sqlAppender.appendSql(" returning ");
            sqlAppender.appendSql(HANAJsonValueFunction.jsonValueReturningType(AbstractSqlAstTranslator.getCastTypeName(arguments.returningType(), walker.getSessionFactory().getTypeConfiguration())));
        }
    }

    static boolean isEncodedBoolean(JdbcMapping type) {
        return type.getJdbcType().isBoolean();
    }
}

