/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.beans.internal;

import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.container.spi.ContainedBean;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;

public final class Helper {
    private Helper() {
    }

    public static String determineBeanCacheKey(Class<?> beanType) {
        return beanType.getName();
    }

    public static String determineBeanCacheKey(String name, Class<?> beanType) {
        return beanType.getName() + ":" + name;
    }

    public static boolean allowExtensionsInCdi(ServiceRegistry serviceRegistry) {
        return serviceRegistry.requireService(ConfigurationService.class).getSetting("hibernate.cdi.extensions", StandardConverters.BOOLEAN, Boolean.valueOf(false));
    }

    public static @Nullable BeanContainer getBeanContainer(ServiceRegistry serviceRegistry) {
        return Helper.allowExtensionsInCdi(serviceRegistry) ? serviceRegistry.requireService(ManagedBeanRegistry.class).getBeanContainer() : null;
    }

    public static <T> @Nullable T getBean(@Nullable BeanContainer container, Class<T> beanType, boolean canUseCachedReferences, boolean useJpaCompliantCreation, @Nullable Supplier<T> fallbackSupplier) {
        return container == null ? null : (T)Helper.containedBean(container, beanType, canUseCachedReferences, useJpaCompliantCreation, fallbackSupplier).getBeanInstance();
    }

    private static <T> ContainedBean<T> containedBean(BeanContainer container, Class<T> beanType, final boolean canUseCachedReferences, final boolean useJpaCompliantCreation, final Supplier<T> fallbackSupplier) {
        return container.getBean(beanType, new BeanContainer.LifecycleOptions(){

            @Override
            public boolean canUseCachedReferences() {
                return canUseCachedReferences;
            }

            @Override
            public boolean useJpaCompliantCreation() {
                return useJpaCompliantCreation;
            }
        }, new BeanInstanceProducer(){

            @Override
            public <B> B produceBeanInstance(Class<B> beanType) {
                return fallbackSupplier != null ? (B)fallbackSupplier.get() : null;
            }

            @Override
            public <B> B produceBeanInstance(String name, Class<B> beanType) {
                throw new UnsupportedOperationException("The method shouldn't be called");
            }
        });
    }
}

