/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Objects;
import java.util.Set;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

@ProtoTypeId(value=65580)
public class GroupAddedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    @ProtoField(value=2)
    final String realmId;
    @ProtoField(value=3)
    final String parentId;

    private GroupAddedEvent(String groupId, String realmId, String parentId) {
        super(groupId);
        this.realmId = Objects.requireNonNull(realmId);
        this.parentId = parentId;
    }

    @ProtoFactory
    static GroupAddedEvent protoFactory(String id, String realmId, String parentId) {
        return new GroupAddedEvent(id, realmId, parentId);
    }

    public static GroupAddedEvent create(String groupId, String parentId, String realmId) {
        return new GroupAddedEvent(groupId, realmId, parentId);
    }

    public String toString() {
        return String.format("GroupAddedEvent [ realmId=%s, groupId=%s ]", this.realmId, this.getId());
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.groupQueriesInvalidations(this.realmId, invalidations);
        if (this.parentId != null) {
            invalidations.add(this.parentId);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupAddedEvent that = (GroupAddedEvent)o;
        return this.realmId.equals(that.realmId) && Objects.equals(this.parentId, that.parentId);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.realmId.hashCode();
        result = 31 * result + Objects.hashCode(this.parentId);
        return result;
    }
}

