/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl.wrappers;

import io.smallrye.context.CleanAutoCloseable;
import io.smallrye.context.impl.CapturedContextState;
import io.smallrye.context.impl.Contextualized;
import java.util.function.Consumer;

public final class SlowContextualConsumer<T>
implements Consumer<T>,
Contextualized {
    private final CapturedContextState state;
    private final Consumer<T> consumer;

    public SlowContextualConsumer(CapturedContextState state, Consumer<T> consumer) {
        this.state = state;
        this.consumer = consumer;
    }

    @Override
    public void accept(T t) {
        try (CleanAutoCloseable activeState = this.state.begin();){
            this.consumer.accept(t);
        }
    }
}

