/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.owasp.html.Joinable;
import org.owasp.html.JoinedAttributePolicy;
import org.owasp.html.TCB;

@TCB
public interface AttributePolicy {
    public static final AttributePolicy IDENTITY_ATTRIBUTE_POLICY = new AttributePolicy(){

        @Override
        public String apply(String elementName, String attributeName, String value) {
            return value;
        }
    };
    public static final AttributePolicy REJECT_ALL_ATTRIBUTE_POLICY = new AttributePolicy(){

        @Override
        @Nullable
        public String apply(String elementName, String attributeName, String value) {
            return null;
        }
    };

    @Nullable
    public String apply(String var1, String var2, String var3);

    public static interface JoinableAttributePolicy
    extends AttributePolicy,
    Joinable<JoinableAttributePolicy> {
    }

    public static final class Util {
        @CheckReturnValue
        public static final AttributePolicy join(AttributePolicy ... policies) {
            AttributePolicyJoiner joiner = new AttributePolicyJoiner();
            for (AttributePolicy p : policies) {
                if (p == null) continue;
                joiner.unroll(p);
            }
            return (AttributePolicy)joiner.join();
        }

        static final class AttributePolicyJoiner
        extends Joinable.JoinHelper<AttributePolicy, JoinableAttributePolicy> {
            AttributePolicyJoiner() {
                super(AttributePolicy.class, JoinableAttributePolicy.class, REJECT_ALL_ATTRIBUTE_POLICY, IDENTITY_ATTRIBUTE_POLICY);
            }

            @Override
            Optional<List<AttributePolicy>> split(AttributePolicy x) {
                if (x instanceof JoinedAttributePolicy) {
                    return Optional.of(((JoinedAttributePolicy)x).policies);
                }
                return Optional.empty();
            }

            @Override
            AttributePolicy rejoin(Set<? extends AttributePolicy> xs) {
                return new JoinedAttributePolicy(xs);
            }
        }
    }
}

