/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.keycloak.common.util.Time;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.workflow.WorkflowExecutor;

public final class WorkflowTask
extends AbstractKeycloakTransaction
implements Runnable {
    private final Runnable task;
    private final WorkflowExecutor executor;
    private final String id;
    private CompletableFuture<Void> future;
    private long startTime;
    private AtomicReference<Thread> thread;

    WorkflowTask(WorkflowExecutor executor, Runnable task) {
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(task, "task");
        this.executor = executor;
        this.task = task;
        this.id = KeycloakModelUtils.generateId();
    }

    @Override
    public void run() {
        if (this.thread.compareAndSet(null, Thread.currentThread())) {
            this.task.run();
        }
    }

    protected void commitImpl() {
        this.startTime = Time.currentTimeMillis();
        this.thread = new AtomicReference();
        this.future = this.executor.submit(this);
    }

    protected void rollbackImpl() {
        this.future = CompletableFuture.failedFuture(new RuntimeException("Parent transaction rolled back"));
    }

    public boolean isActive() {
        return this.future != null && !this.future.isDone();
    }

    public boolean isScheduled() {
        return this.future == null;
    }

    public boolean isDone() {
        return this.future != null && this.future.isDone();
    }

    public boolean isCompletedExceptionally() {
        return this.future != null && this.future.isCompletedExceptionally();
    }

    public Throwable getThrowable() {
        if (this.future != null && this.future.isCompletedExceptionally()) {
            try {
                this.future.join();
            }
            catch (Throwable t) {
                return t;
            }
        }
        return null;
    }

    public String toString() {
        String status = this.isScheduled() ? "SCHEDULED" : (this.isActive() ? "ACTIVE" : (this.isCompletedExceptionally() ? "FAILED" : "SUCCESS"));
        return "id: " + this.id + ", executionTime: " + (System.currentTimeMillis() - this.startTime) + "ms , status: " + status + ", task: [" + this.task.toString() + "]";
    }

    public void cancel() {
        if (this.future != null) {
            this.future.cancel(true);
            if (this.thread.get() != null) {
                this.thread.get().interrupt();
            }
        }
    }
}

