/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.email;

import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerTransaction;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class EmailEventListenerProvider
implements EventListenerProvider {
    private static final Logger log = Logger.getLogger(EmailEventListenerProvider.class);
    private KeycloakSession session;
    private RealmProvider model;
    private Set<EventType> includedEvents;
    private EventListenerTransaction tx = new EventListenerTransaction(null, this::sendEmail);
    private final KeycloakSessionFactory sessionFactory;

    public EmailEventListenerProvider(KeycloakSession session, Set<EventType> includedEvents) {
        this.session = session;
        this.model = session.realms();
        this.includedEvents = includedEvents;
        this.session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.tx);
        this.sessionFactory = session.getKeycloakSessionFactory();
    }

    public void onEvent(Event event) {
        if (this.includedEvents.contains(event.getType()) && event.getRealmId() != null && event.getUserId() != null) {
            this.tx.addEvent(event);
        }
    }

    private void sendEmail(final Event event) {
        final HttpRequest request = this.session.getContext().getHttpRequest();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                KeycloakContext context = session.getContext();
                RealmModel realm = session.realms().getRealm(event.getRealmId());
                context.setRealm(realm);
                String clientId = event.getClientId();
                if (clientId != null) {
                    ClientModel client = realm.getClientByClientId(clientId);
                    context.setClient(client);
                }
                context.setHttpRequest(request);
                UserModel user = session.users().getUserById(realm, event.getUserId());
                if (user != null && user.getEmail() != null && user.isEmailVerified()) {
                    try {
                        EmailTemplateProvider emailTemplateProvider = (EmailTemplateProvider)session.getProvider(EmailTemplateProvider.class);
                        emailTemplateProvider.setRealm(realm).setUser(user).sendEvent(event);
                    }
                    catch (EmailException e) {
                        log.error((Object)"Failed to send type mail", (Throwable)e);
                    }
                }
            }
        });
    }

    public void onEvent(AdminEvent event, boolean includeRepresentation) {
    }

    public void close() {
    }
}

