/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.api.saml.v2.response.SAML2Response;
import org.keycloak.saml.processing.api.util.DeflateUtil;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.web.util.PostBindingUtil;
import org.keycloak.saml.processing.web.util.RedirectBindingUtil;

public class SAMLRequestParser {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected static Logger log = Logger.getLogger(SAMLRequestParser.class);

    public static SAMLDocumentHolder parseRequestRedirectBinding(String samlMessage) {
        return SAMLRequestParser.parseRequestRedirectBinding(samlMessage, DeflateUtil.DEFAULT_MAX_INFLATING_SIZE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SAMLDocumentHolder parseRequestRedirectBinding(String samlMessage, long maxInflatingSize) {
        try (InputStream is = RedirectBindingUtil.base64DeflateDecode(samlMessage, maxInflatingSize);){
            if (log.isDebugEnabled()) {
                String message = StreamUtil.readString((InputStream)is, (Charset)GeneralConstants.SAML_CHARSET);
                log.debug((Object)"SAML Redirect Binding");
                log.debug((Object)message);
                SAMLDocumentHolder sAMLDocumentHolder2 = SAML2Request.getSAML2ObjectFromStream(new ByteArrayInputStream(message.getBytes(GeneralConstants.SAML_CHARSET)));
                return sAMLDocumentHolder2;
            }
            SAMLDocumentHolder sAMLDocumentHolder = SAML2Request.getSAML2ObjectFromStream(is);
            return sAMLDocumentHolder;
        }
        catch (Exception e) {
            logger.samlBase64DecodingError(e);
            return null;
        }
    }

    public static SAMLDocumentHolder parseRequestPostBinding(String samlMessage) {
        byte[] samlBytes = PostBindingUtil.base64Decode(samlMessage);
        if (log.isDebugEnabled()) {
            String str = new String(samlBytes, GeneralConstants.SAML_CHARSET);
            log.debug((Object)"SAML POST Binding");
            log.debug((Object)str);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(samlBytes);
        try {
            return SAML2Request.getSAML2ObjectFromStream(is);
        }
        catch (Exception e) {
            logger.samlBase64DecodingError(e);
            return null;
        }
    }

    public static SAMLDocumentHolder parseResponsePostBinding(String samlMessage) {
        byte[] samlBytes = PostBindingUtil.base64Decode(samlMessage);
        log.debug((Object)"SAML POST Binding");
        return SAMLRequestParser.parseResponseDocument(samlBytes);
    }

    public static SAMLDocumentHolder parseResponseDocument(byte[] samlBytes) {
        if (log.isDebugEnabled()) {
            String str = new String(samlBytes, GeneralConstants.SAML_CHARSET);
            log.debug((Object)str);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(samlBytes);
        SAML2Response response = new SAML2Response();
        try {
            response.getSAML2ObjectFromStream(is);
            return response.getSamlDocumentHolder();
        }
        catch (Exception e) {
            logger.samlBase64DecodingError(e);
            return null;
        }
    }

    public static SAMLDocumentHolder parseResponseRedirectBinding(String samlMessage) {
        return SAMLRequestParser.parseResponseRedirectBinding(samlMessage, DeflateUtil.DEFAULT_MAX_INFLATING_SIZE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SAMLDocumentHolder parseResponseRedirectBinding(String samlMessage, long maxInflatingSize) {
        try (InputStream is = RedirectBindingUtil.base64DeflateDecode(samlMessage, maxInflatingSize);){
            if (log.isDebugEnabled()) {
                String message = StreamUtil.readString((InputStream)is, (Charset)GeneralConstants.SAML_CHARSET);
                log.debug((Object)"SAML Redirect Binding");
                log.debug((Object)message);
                SAML2Response response = new SAML2Response();
                response.getSAML2ObjectFromStream(new ByteArrayInputStream(message.getBytes(GeneralConstants.SAML_CHARSET)));
                SAMLDocumentHolder sAMLDocumentHolder2 = response.getSamlDocumentHolder();
                return sAMLDocumentHolder2;
            }
            SAML2Response response = new SAML2Response();
            response.getSAML2ObjectFromStream(is);
            SAMLDocumentHolder sAMLDocumentHolder = response.getSamlDocumentHolder();
            return sAMLDocumentHolder;
        }
        catch (Exception e) {
            logger.samlBase64DecodingError(e);
            return null;
        }
    }
}

