/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.impl.TabListPopupAction;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class ButtonFactory {
    public static JButton createDropDownButton(Controller controller) {
        JButton btn = new JButton(new TabListPopupAction(controller));
        Icon icon = UIManager.getIcon("nb.multitabs.button.dropdown.icon");
        if (icon == null) {
            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/core/multitabs/resources/down.png", (boolean)true);
        }
        btn.setIcon(icon);
        btn.setActionCommand("pressed");
        btn.setFocusable(false);
        btn.setToolTipText(NbBundle.getMessage(ButtonFactory.class, (String)"Hint_DocumentList"));
        return btn;
    }

    public static JButton createMaximizeButton(final Controller controller) {
        final JButton btn = new JButton();
        Icon icon = UIManager.getIcon("nb.multitabs.button.maximize.icon");
        if (icon == null) {
            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/core/multitabs/resources/maximize.png", (boolean)true);
        }
        btn.setIcon(icon);
        btn.setToolTipText(NbBundle.getMessage(ButtonFactory.class, (String)"Hint_MaximizeRestore"));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                controller.postActionEvent(new TabActionEvent((Object)btn, "maximize", -1));
            }
        });
        btn.setFocusable(false);
        return btn;
    }

    public static JButton createScrollLeftButton(Action scrollAction) {
        TimerButton btn = new TimerButton(scrollAction);
        Icon icon = UIManager.getIcon("nb.multitabs.button.left.icon");
        if (icon == null) {
            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/core/multitabs/resources/left.png", (boolean)true);
        }
        btn.setIcon(icon);
        btn.setToolTipText(NbBundle.getMessage(ButtonFactory.class, (String)"Hint_ScrollLeft"));
        return btn;
    }

    public static JButton createScrollRightButton(Action scrollAction) {
        TimerButton btn = new TimerButton(scrollAction);
        Icon icon = UIManager.getIcon("nb.multitabs.button.right.icon");
        if (icon == null) {
            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/core/multitabs/resources/right.png", (boolean)true);
        }
        btn.setIcon(icon);
        btn.setToolTipText(NbBundle.getMessage(ButtonFactory.class, (String)"Hint_ScrollRight"));
        return btn;
    }

    private static class TimerButton
    extends JButton
    implements ActionListener {
        Timer timer = null;
        int count = 0;

        public TimerButton(Action a) {
            this.setAction(a);
            this.setFocusable(false);
        }

        private Timer getTimer() {
            if (this.timer == null) {
                this.timer = new Timer(400, this);
                this.timer.setRepeats(true);
            }
            return this.timer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ++this.count;
            if (this.count > 2) {
                if (this.count > 5) {
                    this.timer.setDelay(75);
                } else {
                    this.timer.setDelay(200);
                }
            }
            this.performAction();
        }

        private void performAction() {
            if (!this.isEnabled()) {
                this.stopTimer();
                return;
            }
            this.getAction().actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }

        private void startTimer() {
            Timer t = this.getTimer();
            if (t.isRunning()) {
                return;
            }
            this.repaint();
            t.setDelay(400);
            t.start();
        }

        private void stopTimer() {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.repaint();
            this.count = 0;
        }

        @Override
        protected void processMouseEvent(MouseEvent me) {
            if (this.isEnabled() && me.getID() == 501) {
                this.startTimer();
            } else if (me.getID() == 502) {
                this.stopTimer();
            }
            super.processMouseEvent(me);
        }

        @Override
        protected void processFocusEvent(FocusEvent fe) {
            super.processFocusEvent(fe);
            if (fe.getID() == 1005) {
                this.stopTimer();
            }
        }
    }
}

